/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="query.continuous.ContinuousQueryProfilingTest")
public class ContinuousQueryProfilingTest
extends MultipleCacheManagersTest {
    private final int NUM_NODES = 10;
    private final int NUM_OWNERS = 3;

    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(c, 10);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = ContinuousQueryProfilingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        c.clustering().hash().numOwners(3);
        return c;
    }

    public void testContinuousQueryPerformance() {
        long t1 = this.testContinuousQueryPerformance(false);
        long t2 = this.testContinuousQueryPerformance(true);
        log.infof("ContinuousQueryProfilingTest.testContinuousQueryPerformance doRegisterListener=false took %d ms\n", (Object)(t1 / 1000000L));
        log.infof("ContinuousQueryProfilingTest.testContinuousQueryPerformance doRegisterListener=true  took %d ms\n", (Object)(t2 / 1000000L));
    }

    private long testContinuousQueryPerformance(boolean doRegisterListener) {
        Cache cache;
        Person value;
        int i;
        int numEntries = 100000;
        int numListeners = 1000;
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache(0));
        if (doRegisterListener) {
            Query query = this.makeQuery(this.cache(0));
            for (int i2 = 0; i2 < 1000; ++i2) {
                cq.addContinuousQueryListener(query, (ContinuousQueryListener)new ContinuousQueryListener<Object, Object>(){});
            }
        }
        long startTs = System.nanoTime();
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        for (i = 0; i < 100000; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            cache = this.cache(i % 10);
            cache.put((Object)value.getName(), (Object)value);
        }
        long endTs = System.nanoTime();
        cq.removeAllListeners();
        return endTs - startTs;
    }

    private Query makeQuery(Cache c) {
        QueryFactory qf = Search.getQueryFactory((Cache)c);
        return qf.from(Person.class).having("age").gte((Object)18).build();
    }
}

