/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.SearchManager;
import org.infinispan.query.SecurityActions;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.continuous.impl.ContinuousQueryImpl;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryEngine;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.embedded.impl.IckleCacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.SearchManagerImpl;
import org.infinispan.query.logging.Log;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.util.logging.LogFactory;

public final class Search {
    private static final Log log = (Log)LogFactory.getLog(Search.class, Log.class);

    private Search() {
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString) {
        return Search.makeFilter(queryString, null);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString, Map<String, Object> namedParameters) {
        IckleFilterAndConverter filterAndConverter = new IckleFilterAndConverter(queryString, namedParameters, ReflectionMatcher.class);
        return new IckleCacheEventFilterConverter(filterAndConverter);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(Query query) {
        BaseQuery baseQuery = (BaseQuery)query;
        return Search.makeFilter(baseQuery.getQueryString(), baseQuery.getParameters());
    }

    public static QueryFactory getQueryFactory(Cache<?, ?> cache) {
        if (cache == null || cache.getAdvancedCache() == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        AdvancedCache advancedCache = cache.getAdvancedCache();
        Search.ensureAccessPermissions(advancedCache);
        EmbeddedQueryEngine queryEngine = (EmbeddedQueryEngine)SecurityActions.getCacheComponentRegistry(advancedCache).getComponent(EmbeddedQueryEngine.class);
        if (queryEngine == null) {
            throw log.queryModuleNotInitialised();
        }
        return new EmbeddedQueryFactory(queryEngine);
    }

    public static <K, V> ContinuousQuery<K, V> getContinuousQuery(Cache<K, V> cache) {
        return new ContinuousQueryImpl<K, V>(cache);
    }

    public static SearchManager getSearchManager(Cache<?, ?> cache) {
        if (cache == null || cache.getAdvancedCache() == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        AdvancedCache advancedCache = cache.getAdvancedCache();
        Search.ensureAccessPermissions(advancedCache);
        return new SearchManagerImpl(advancedCache);
    }

    private static void ensureAccessPermissions(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
    }
}

