/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.AsyncIndexConfigValidationTest")
public class AsyncIndexConfigValidationTest
extends AbstractInfinispanTest {
    public void testWithDefaultIndexCaches() throws Exception {
        TestingUtil.withCacheManager(TestCacheManagerFactory::createClusteredCacheManager, cm -> {
            Configuration indexConfig = this.createAsyncIndexConfig();
            cm.defineConfiguration("LuceneIndexesData", indexConfig);
            cm.defineConfiguration("LuceneIndexesLocking", indexConfig);
            cm.defineConfiguration("LuceneIndexesMetadata", indexConfig);
            cm.defineConfiguration("userCache", this.createUserCacheConfig());
            Cache userCache = cm.getCache("userCache");
            this.assertValidationExceptionThrown(() -> {
                Person cfr_ignored_0 = (Person)userCache.put((Object)"1", (Object)new Person());
            });
        });
    }

    public void testWithCustomIndexCaches() throws Exception {
        TestingUtil.withCacheManager(TestCacheManagerFactory::createClusteredCacheManager, cm -> {
            Configuration indexConfig = this.createAsyncIndexConfig();
            cm.defineConfiguration("data", indexConfig);
            cm.defineConfiguration("lock", indexConfig);
            cm.defineConfiguration("metadata", indexConfig);
            cm.defineConfiguration("userCache", this.createUserCacheConfigWithCustomIndexCaches());
            Cache userCache = cm.getCache("userCache");
            this.assertValidationExceptionThrown(() -> {
                Person cfr_ignored_0 = (Person)userCache.put((Object)"1", (Object)new Person());
            });
        });
    }

    private Throwable getRootCauseException(Throwable re) {
        Throwable cause = re.getCause();
        if (cause instanceof RuntimeException) {
            return this.getRootCauseException(cause);
        }
        return re;
    }

    private void assertValidationExceptionThrown(Runnable operation) {
        try {
            operation.run();
        }
        catch (RuntimeException ex) {
            Throwable cause = this.getRootCauseException(ex);
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            String message = cause.getMessage();
            Assert.assertTrue((boolean)message.matches("ISPN(\\d)*: Lucene Directory for index 'person' cannot use cache '(.*)' with mode 'REPL_ASYNC'. Only SYNC caches are supported!"));
        }
    }

    private Configuration createAsyncIndexConfig() {
        ConfigurationBuilder indexCfgBuilder = new ConfigurationBuilder();
        indexCfgBuilder.indexing().index(Index.NONE);
        indexCfgBuilder.clustering().cacheMode(CacheMode.REPL_ASYNC);
        return indexCfgBuilder.build();
    }

    private Configuration createUserCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("error_handler", StaticTestingErrorHandler.class.getName());
        return builder.build();
    }

    private Configuration createUserCacheConfigWithCustomIndexCaches() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("default.locking_cachename", "lock").addProperty("default.data_cachename", "data").addProperty("default.metadata_cachename", "metadata").addProperty("error_handler", StaticTestingErrorHandler.class.getName());
        return builder.build();
    }
}

