/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.spatial;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.Coordinates;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.spatial.QuerySpatialTest")
public class QuerySpatialTest
extends SingleCacheManagerTest {
    public QuerySpatialTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(CitySpatial.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testSpatialQueries() {
        this.loadData();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(CitySpatial.class).get().spatial().onField("city_location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        AssertJUnit.assertEquals((int)0, (int)found.size());
        query = Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(CitySpatial.class).get().spatial().onField("city_location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
    }

    private void loadData() {
        CitySpatial city1 = new CitySpatial(24.0, 32.0, "Some City");
        this.cache.put((Object)"key1", (Object)city1);
    }

    @Indexed
    @Spatial(name="city_location", spatialMode=SpatialMode.HASH)
    public static class CitySpatial
    implements Coordinates {
        private Double latitude;
        private Double longitude;
        @Field(store=Store.YES)
        String name;

        public CitySpatial(Double latitude, Double longitude, String name) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.name = name;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }
    }
}

