/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.query.affinity.RpcDetail;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;

class RpcCollector {
    private List<RpcDetail> rpcCollection = new ArrayList<RpcDetail>();
    private final List<Class<? extends BaseRpcCommand>> stateTransferCommands = Arrays.asList(StateRequestCommand.class, StateResponseCommand.class);
    private Predicate<RpcDetail> stateTransferPredicate = rpc -> this.stateTransferCommands.contains(rpc.getCommand().getClass());
    private Predicate<RpcDetail> sameDestinationPredicate = RpcDetail::isRpcToItself;

    RpcCollector() {
    }

    private Predicate<RpcDetail> cacheNamePredicate(String cacheName) {
        return rpc -> rpc.getCacheName().equals(cacheName);
    }

    synchronized void addRPC(RpcDetail rpcDetail) {
        this.rpcCollection.add(rpcDetail);
    }

    synchronized Set<RpcDetail> getRpcsForCache(String cacheName) {
        return this.rpcCollection.stream().filter(this.sameDestinationPredicate.negate()).filter(this.stateTransferPredicate.negate()).filter(this.cacheNamePredicate(cacheName)).collect(Collectors.toSet());
    }
}

