/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.blackbox.ClusteredQueryTest;
import org.infinispan.query.test.Person;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredQueryMultipleCachesTest")
public class ClusteredQueryMultipleCachesTest
extends ClusteredQueryTest {
    Cache<String, Person> cacheBMachine1;
    Cache<String, Person> cacheBMachine2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredQueryMultipleCachesTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        cacheCfg.indexing().index(Index.PRIMARY_OWNER).addIndexedEntity(Person.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        List caches = this.createClusteredCaches(2, cacheCfg, new String[]{"cacheA", "cacheB"});
        this.cacheAMachine1 = (Cache)((List)caches.get(0)).get(0);
        this.cacheAMachine2 = (Cache)((List)caches.get(1)).get(0);
        this.cacheBMachine1 = (Cache)((List)caches.get(0)).get(1);
        this.cacheBMachine2 = (Cache)((List)caches.get(1)).get(1);
        this.populateCache();
    }

    @Override
    protected void prepareTestData() {
        super.prepareTestData();
        Person person5 = new Person();
        person5.setName("People In Another Cache");
        person5.setBlurb("Also eats grass");
        person5.setAge(5);
        this.cacheBMachine2.put((Object)"anotherNewOne", (Object)person5);
    }
}

