/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.AbstractDelegatingRpcManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.QueryOnTopologyChangeTest")
public class IndexingDuringStateTransferTest
extends MultipleCacheManagersTest {
    private static final String KEY = "k";
    private static final Person RADIM = new Person("Radim", "Tough guy!", 29);
    private static final Person DAN = new Person("Dan", "Not that tough.", 39);
    private static final AnotherGrassEater FLUFFY = new AnotherGrassEater("Fluffy", "Very cute.");
    private ConfigurationBuilder builder;
    private ControlledConsistentHashFactory.Default chf = new ControlledConsistentHashFactory.Default(0, new int[]{1});

    protected void createCacheManagers() throws Throwable {
        this.builder = IndexingDuringStateTransferTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.builder.indexing().index(Index.ALL).addIndexedEntity(Person.class).addIndexedEntity(AnotherGrassEater.class).addProperty("default.directory_provider", "ram").addProperty("error_handler", "org.infinispan.query.helper.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        this.builder.memory().storageType(StorageType.OBJECT);
        this.builder.clustering().hash().numSegments(1).numOwners(2).consistentHashFactory((ConsistentHashFactory)this.chf);
        this.createClusteredCaches(2, this.builder);
    }

    public void testPut() {
        this.test(c -> c.put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    public void testPutIgnoreReturnValue() {
        this.test(c -> c.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    public void testPutMap() {
        this.test(c -> c.putAll(Collections.singletonMap(KEY, FLUFFY)), this::assertFluffyIndexed);
    }

    public void testReplace() {
        this.test(c -> c.replace((Object)KEY, (Object)FLUFFY), this::assertFluffyIndexed);
    }

    public void testRemove() {
        this.test(c -> c.remove((Object)KEY), sm -> {});
    }

    public void testCompute() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> FLUFFY), this::assertFluffyIndexed);
    }

    @Test(enabled=false, description="ISPN-7590")
    public void testComputeRemove() {
        this.test(c -> c.compute((Object)KEY, (SerializableBiFunction & Serializable)(k, old) -> null), sm -> {});
    }

    public void testMerge() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> n), this::assertFluffyIndexed);
    }

    @Test(enabled=false, description="ISPN-7590")
    public void testMergeRemove() {
        this.test(c -> c.merge((Object)KEY, (Object)FLUFFY, (SerializableBiFunction & Serializable)(o, n) -> null), sm -> {});
    }

    private void test(Consumer<Cache> op, Consumer<SearchManager> check) {
        SearchManager sm0 = Search.getSearchManager((Cache)this.cache(0));
        AssertJUnit.assertEquals((int)0, (int)this.queryAll(sm0, Person.class).size());
        this.cache(0).put((Object)KEY, (Object)RADIM);
        this.cache(0).put((Object)"k2", (Object)DAN);
        StaticTestingErrorHandler.assertAllGood(this.cache(0), this.cache(1));
        List<Person> found = this.queryAll(sm0, Person.class);
        AssertJUnit.assertEquals(Arrays.asList(RADIM, DAN), this.sortByAge(found));
        this.chf.setOwnerIndexes(1, new int[]{2});
        this.addClusterEnabledCacheManager(this.builder).getCache();
        this.eventuallyEquals(null, () -> this.cache(0).getAdvancedCache().getDataContainer().get((Object)KEY));
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch allowStateResponse = new CountDownLatch(1);
        this.caches().forEach(c -> {
            RpcManager cfr_ignored_0 = (RpcManager)TestingUtil.wrapComponent((Cache)c, RpcManager.class, original -> new AbstractDelegatingRpcManager((RpcManager)original){

                protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker) {
                    if (command instanceof StateResponseCommand) {
                        try {
                            AssertJUnit.assertTrue((boolean)allowStateResponse.await(10L, TimeUnit.SECONDS));
                        }
                        catch (Exception e) {
                            exception.set(e);
                        }
                    }
                    return super.performRequest(targets, command, collector, invoker);
                }
            });
        });
        this.chf.setOwnerIndexes(0, new int[]{1});
        Future stoppingCacheFuture = this.fork(() -> this.killMember(2));
        TestingUtil.waitForTopologyPhase(Collections.emptyList(), (CacheTopology.Phase)CacheTopology.Phase.READ_OLD_WRITE_ALL, (Cache[])new Cache[]{this.cache(0)});
        AssertJUnit.assertEquals(null, (Object)this.cache(0).getAdvancedCache().getDataContainer().get((Object)KEY));
        op.accept(this.cache(0));
        allowStateResponse.countDown();
        try {
            stoppingCacheFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AssertJUnit.assertEquals(null, exception.get());
        StaticTestingErrorHandler.assertAllGood(this.cache(0), this.cache(1));
        AssertJUnit.assertEquals(Collections.singletonList(DAN), this.queryAll(sm0, Person.class));
        Object value = this.cache(0).get((Object)KEY);
        AssertJUnit.assertFalse((String)("Current value: " + value), (boolean)(value instanceof Person));
        check.accept(sm0);
    }

    private List<Person> sortByAge(List<Person> people) {
        Collections.sort(people, Comparator.comparingInt(Person::getAge));
        return people;
    }

    private <T> List<T> queryAll(SearchManager sm, Class<T> entityType) {
        return sm.getQuery(sm.buildQueryBuilderForClass(entityType).get().all().createQuery(), new Class[]{entityType}).list();
    }

    private void assertFluffyIndexed(SearchManager sm) {
        AssertJUnit.assertEquals(Collections.singletonList(FLUFFY), this.queryAll(sm, AnotherGrassEater.class));
    }
}

