/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dynamicexample;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dynamicexample.DynamicPropertiesEntity;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dynamicexample.DynamicPropertiesTest")
public class DynamicPropertiesTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(DynamicPropertiesEntity.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void searchOnEmptyIndex() {
        this.cache.put((Object)"1", (Object)new DynamicPropertiesEntity().set("name", "OpenBlend 2011").set("city", "Ljubljana").set("location", "castle"));
        this.cache.put((Object)"2", (Object)new DynamicPropertiesEntity().set("name", "JUDCon London 2011").set("city", "London"));
        this.cache.put((Object)"3", (Object)new DynamicPropertiesEntity().set("name", "JavaOne 2011").set("city", "San Francisco").set("awards", "Duke Award to Arquillian"));
        SearchManager qf = Search.getSearchManager((Cache)this.cache);
        QueryBuilder queryBuilder = qf.buildQueryBuilderForClass(DynamicPropertiesEntity.class).get();
        Query query = queryBuilder.phrase().onField("city").sentence("London").createQuery();
        List list = qf.getQuery(query, new Class[0]).list();
        assert (list.size() == 1);
        DynamicPropertiesEntity result = (DynamicPropertiesEntity)list.get(0);
        assert (result.getProperties().get("name").equals("JUDCon London 2011"));
        Query dateQuery = queryBuilder.phrase().onField("name").sentence("2011").createQuery();
        list = qf.getQuery(dateQuery, new Class[0]).list();
        assert (list.size() == 3);
        Query awardsQuery = queryBuilder.phrase().onField("awards").sentence("Duke").createQuery();
        list = qf.getQuery(awardsQuery, new Class[0]).list();
        assert (list.size() == 1);
        result = (DynamicPropertiesEntity)list.get(0);
        assert (result.getProperties().get("city").equals("San Francisco"));
    }
}

