/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.impl.IndexedTypeMaps;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryEngine;
import org.infinispan.query.dsl.embedded.impl.HsQueryRequest;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryDefinition {
    private static final Log log = (Log)LogFactory.getLog(QueryDefinition.class, Log.class);
    private String queryString;
    private HSQuery hsQuery;
    private int maxResults = 100;
    private int firstResult;
    private Set<String> sortableFields;
    private Class<?> indexedType;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>();
    private transient Sort sort;

    public QueryDefinition(String queryString) {
        this.queryString = queryString;
    }

    public QueryDefinition(HSQuery hsQuery) {
        this.hsQuery = hsQuery;
    }

    public Optional<String> getQueryString() {
        return Optional.ofNullable(this.queryString);
    }

    private IndexedTypeMap<CustomTypeMetadata> createMetadata() {
        return IndexedTypeMaps.singletonMapping((IndexedTypeIdentifier)PojoIndexedTypeIdentifier.convertFromLegacy(this.indexedType), () -> this.sortableFields);
    }

    protected QueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return (QueryEngine)cache.getComponentRegistry().getComponent(EmbeddedQueryEngine.class);
    }

    public void initialize(AdvancedCache<?, ?> cache) {
        if (this.hsQuery == null) {
            HsQueryRequest hsQueryRequest;
            QueryEngine queryEngine = this.getQueryEngine(cache);
            if (this.indexedType != null && this.sortableFields != null) {
                IndexedTypeMap<CustomTypeMetadata> metadata = this.createMetadata();
                hsQueryRequest = queryEngine.createHsQuery(this.queryString, metadata, this.namedParameters);
            } else {
                hsQueryRequest = queryEngine.createHsQuery(this.queryString, null, this.namedParameters);
            }
            this.hsQuery = hsQueryRequest.getHsQuery();
            this.sort = hsQueryRequest.getSort();
            this.hsQuery.firstResult(this.firstResult);
            this.hsQuery.maxResults(this.maxResults);
            this.hsQuery.projection(hsQueryRequest.getProjections());
        }
    }

    public HSQuery getHsQuery() {
        if (this.hsQuery == null) {
            throw new IllegalStateException("The QueryDefinition has not been initialized, make sure to call initialize(...) first");
        }
        return this.hsQuery;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        if (this.hsQuery != null) {
            this.hsQuery.maxResults(maxResults);
        }
    }

    public void setNamedParameters(Map<String, Object> params) {
        if (params == null) {
            this.namedParameters.clear();
        } else {
            this.namedParameters.putAll(params);
        }
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        if (this.hsQuery != null) {
            this.hsQuery.firstResult(firstResult);
        }
        this.firstResult = firstResult;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        if (this.queryString != null) {
            throw log.sortNotSupportedWithQueryString();
        }
        this.hsQuery.sort(sort);
        this.sort = sort;
    }

    public void filter(Filter filter) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        this.hsQuery.filter(filter);
    }

    public FullTextFilter enableFullTextFilter(String name) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        return this.hsQuery.enableFullTextFilter(name);
    }

    public void disableFullTextFilter(String name) {
        if (this.queryString != null) {
            throw log.filterNotSupportedWithQueryString();
        }
        this.hsQuery.disableFullTextFilter(name);
    }

    public Set<String> getSortableFields() {
        return this.sortableFields;
    }

    public void setSortableField(Set<String> sortableField) {
        this.sortableFields = sortableField;
    }

    public Class<?> getIndexedType() {
        return this.indexedType;
    }

    public void setIndexedType(Class<?> indexedType) {
        this.indexedType = indexedType;
    }
}

