/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.query.indexmanager.IndexingBackend;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class LocalIndexingBackend
implements IndexingBackend {
    private static final Log log = (Log)LogFactory.getLog(LocalIndexingBackend.class, Log.class);
    private final WorkspaceHolder workspaceHolder;

    public LocalIndexingBackend(WorkspaceHolder workspaceHolder) {
        this.workspaceHolder = workspaceHolder;
    }

    @Override
    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor, IndexManager indexManager) {
        log.applyingChangeListLocally(workList);
        this.workspaceHolder.applyWork(workList, monitor);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor, IndexManager indexManager) {
        this.workspaceHolder.applyStreamWork(singleOperation, monitor);
    }

    @Override
    public boolean isMasterLocal() {
        return true;
    }

    @Override
    public void flushAndClose(IndexingBackend replacement) {
        this.workspaceHolder.close();
        log.debug("Downgraded from Master role: Index lock released.");
    }

    public String toString() {
        return "LocalIndexingBackend";
    }
}

