/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.continuous.CallCountingCQResultListener;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.continuous.ContinuousQueryTest")
public class ContinuousQueryTest
extends SingleCacheManagerTest {
    protected ControlledTimeService timeService = new ControlledTimeService();

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cacheConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cacheConfiguration);
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
        return cm;
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp=".*ISPN028521:.*")
    public void testDisallowFullTextQuery() {
        Query query = Search.getQueryFactory((Cache)this.cache()).create("from org.infinispan.query.test.Person where name : 'john'");
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache());
        cq.addContinuousQueryListener(query, new CallCountingCQResultListener());
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp=".*ISPN028509:.*")
    public void testDisallowGroupingAndAggregation() {
        Query query = Search.getQueryFactory((Cache)this.cache()).from(Person.class).select(new Expression[]{Expression.max((String)"age")}).having("age").gte((Object)20).build();
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache());
        cq.addContinuousQueryListener(query, new CallCountingCQResultListener());
    }

    public void testContinuousQuery() {
        Person value;
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            Person value2 = new Person();
            value2.setName("John");
            value2.setAge(30 + i2);
            this.cache().put((Object)i2, (Object)value2);
        }
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache());
        Query query = (Query)qf.from(Person.class).select(new String[]{"age"}).having("age").lte((Object)Expression.param((String)"ageParam")).build().setParameter("ageParam", (Object)30);
        CallCountingCQResultListener listener = new CallCountingCQResultListener();
        cq.addContinuousQueryListener(query, listener);
        Map joined = listener.getJoined();
        Map updated = listener.getUpdated();
        Map left = listener.getLeft();
        AssertJUnit.assertEquals((int)1, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        for (i = 0; i < 10; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 25);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)5, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 40);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)2, (int)left.size());
        left.clear();
        for (i = 4; i < 20; ++i) {
            this.cache().remove((Object)i);
        }
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)2, (int)left.size());
        left.clear();
        this.cache().clear();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)2, (int)left.size());
        left.clear();
        for (i = 0; i < 2; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 20);
            this.cache().put((Object)i, (Object)value, 5L, TimeUnit.MILLISECONDS);
        }
        AssertJUnit.assertEquals((int)2, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        this.timeService.advance(6L);
        this.cache.getAdvancedCache().getExpirationManager().processExpiration();
        AssertJUnit.assertEquals((int)0, (int)this.cache().size());
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)2, (int)left.size());
        left.clear();
        cq.removeContinuousQueryListener(listener);
        for (i = 0; i < 3; ++i) {
            value = new Person();
            value.setName("John");
            value.setAge(i + 20);
            this.cache().put((Object)i, (Object)value);
        }
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
    }

    public void testContinuousQueryChangingParameter() {
        for (int i = 0; i < 2; ++i) {
            Person value = new Person();
            value.setName("John");
            value.setAge(30 + i);
            this.cache().put((Object)i, (Object)value);
        }
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        ContinuousQuery cq = Search.getContinuousQuery((Cache)this.cache());
        Query query = qf.from(Person.class).select(new String[]{"age"}).having("age").lte((Object)Expression.param((String)"ageParam")).build();
        query.setParameter("ageParam", (Object)30);
        CallCountingCQResultListener listener = new CallCountingCQResultListener();
        cq.addContinuousQueryListener(query, listener);
        Map joined = listener.getJoined();
        Map updated = listener.getUpdated();
        Map left = listener.getLeft();
        AssertJUnit.assertEquals((int)1, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        cq.removeContinuousQueryListener(listener);
        query.setParameter("ageParam", (Object)32);
        listener = new CallCountingCQResultListener();
        cq.addContinuousQueryListener(query, listener);
        joined = listener.getJoined();
        left = listener.getLeft();
        AssertJUnit.assertEquals((int)2, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        cq.removeContinuousQueryListener(listener);
    }

    public void testTwoSimilarCQ() {
        QueryFactory qf = Search.getQueryFactory((Cache)this.cache());
        CallCountingCQResultListener listener = new CallCountingCQResultListener();
        Query query1 = ((FilterConditionContext)qf.from(Person.class).having("age").lte((Object)30).and().having("name").eq((Object)"John")).or().having("name").eq((Object)"Johny").build();
        ContinuousQuery cq1 = Search.getContinuousQuery((Cache)this.cache());
        cq1.addContinuousQueryListener(query1, listener);
        Query query2 = qf.from(Person.class).having("age").lte((Object)30).or().having("name").eq((Object)"Joe").build();
        ContinuousQuery cq2 = Search.getContinuousQuery((Cache)this.cache());
        cq2.addContinuousQueryListener(query2, listener);
        Map joined = listener.getJoined();
        Map updated = listener.getUpdated();
        Map left = listener.getLeft();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)0, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        Person value = new Person();
        value.setName("John");
        value.setAge(20);
        this.cache().put((Object)1, (Object)value);
        AssertJUnit.assertEquals((int)1, (int)joined.size());
        AssertJUnit.assertEquals((int)2, (int)joined.get(1));
        AssertJUnit.assertEquals((int)0, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        value = new Person();
        value.setName("Joe");
        this.cache().replace((Object)1, (Object)value);
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)1, (int)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("Joe");
        value.setAge(31);
        this.cache().replace((Object)1, (Object)value);
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("John");
        value.setAge(29);
        this.cache().put((Object)1, (Object)value);
        AssertJUnit.assertEquals((int)1, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)joined.get(1));
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        left.clear();
        value = new Person();
        value.setName("Johny");
        value.setAge(29);
        this.cache().put((Object)1, (Object)value);
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)updated.size());
        AssertJUnit.assertEquals((int)0, (int)left.size());
        joined.clear();
        left.clear();
        this.cache().clear();
        AssertJUnit.assertEquals((int)0, (int)joined.size());
        AssertJUnit.assertEquals((int)1, (int)left.size());
        AssertJUnit.assertEquals((int)2, (int)left.get(1));
        AssertJUnit.assertEquals((int)1, (int)updated.size());
    }
}

