/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.distributed.NonSerializableKeyType;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistributedMassIndexingTest")
public class DistributedMassIndexingTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 3;
    protected static final String[] neededCacheNames = new String[]{"default", "LuceneIndexesMetadata", "LuceneIndexesData", "LuceneIndexesLocking"};
    protected List<Cache> caches = new ArrayList<Cache>(3);

    protected String getConfigurationFile() {
        return "dynamic-indexing-distribution.xml";
    }

    protected void createCacheManagers() throws Throwable {
        for (int i = 0; i < 3; ++i) {
            EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)this.getConfigurationFile());
            this.registerCacheManager(new CacheContainer[]{cacheManager});
            Cache cache = cacheManager.getCache();
            this.caches.add(cache);
        }
        this.waitForClusterToForm(neededCacheNames);
    }

    public void testReindexing() throws Exception {
        this.caches.get(0).put(this.key("F1NUM"), (Object)new Car("megane", "white", 300));
        this.verifyFindsCar(1, "megane");
        this.caches.get(1).put(this.key("F2NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.caches.get(1).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("F3NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(3, "megane");
        this.caches.get(2).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).remove(this.key("F2NUM"));
        this.verifyFindsCar(3, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(2, "megane");
    }

    public void testPartiallyReindex() throws Exception {
        this.caches.get(0).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("F1NUM"), (Object)new Car("megane", "white", 300));
        Search.getSearchManager((Cache)this.cache(0)).getMassIndexer().reindex(new Object[]{this.key("F1NUM")}).get();
        this.verifyFindsCar(1, "megane");
        this.caches.get(0).remove(this.key("F1NUM"));
        this.verifyFindsCar(0, "megane");
    }

    protected Object key(String keyId) {
        return new NonSerializableKeyType(keyId);
    }

    protected void rebuildIndexes() throws Exception {
        Cache cache = this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        searchManager.getMassIndexer().start();
    }

    protected void verifyFindsCar(int expectedCount, String carMake) throws Exception {
        for (Cache cache : this.caches) {
            StaticTestingErrorHandler.assertAllGood(cache);
            this.verifyFindsCar(cache, expectedCount, carMake);
        }
    }

    protected void verifyFindsCar(Cache cache, int expectedCount, String carMake) throws Exception {
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        QueryBuilder carQueryBuilder = searchManager.buildQueryBuilderForClass(Car.class).get();
        Query fullTextQuery = carQueryBuilder.keyword().onField("make").matching((Object)carMake).createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(fullTextQuery, new Class[]{Car.class});
        AssertJUnit.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
    }

    protected boolean cleanupAfterTest() {
        return false;
    }

    protected boolean cleanupAfterMethod() {
        return true;
    }

    @BeforeMethod
    public void createBeforeMethod() throws Throwable {
        this.caches.clear();
        super.createBeforeMethod();
    }
}

