/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.infinispan.query.dsl.embedded.impl.model.Company;

@Indexed
public class Employee {
    @DocumentId
    public String id;
    @Field(analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
    public String name;
    @Field
    public long position;
    @Field(indexNullAs="-1")
    public long code;
    @Field
    public String text;
    @Field(analyze=Analyze.NO)
    public String title;
    @Fields(value={@Field(name="analyzedInfo", analyze=Analyze.YES), @Field(name="someMoreInfo", analyze=Analyze.NO), @Field(name="sameInfo", analyze=Analyze.NO)})
    public String otherInfo;
    @IndexedEmbedded(indexNullAs="__DEFAULT_NULL_TOKEN__")
    public Company author;
    @IndexedEmbedded
    public List<ContactDetails> contactDetails = new ArrayList<ContactDetails>();
    @IndexedEmbedded
    public List<ContactDetails> alternativeContactDetails = new ArrayList<ContactDetails>();

    public static class ContactDetails {
        @Field(analyze=Analyze.NO)
        public String email;
        @Field(analyze=Analyze.NO)
        public String phoneNumber;
        @IndexedEmbedded
        public ContactAddress address;

        public static class ContactAddress {
            @Field(analyze=Analyze.NO)
            public String address;
            @Field(analyze=Analyze.NO)
            public String postCode;
            @IndexedEmbedded(depth=3)
            public List<ContactAddress> alternatives = new ArrayList<ContactAddress>();
        }
    }
}

