/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.QueryResultLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.EagerIteratorTest")
public class EagerIteratorTest {
    List<String> keys;
    List<EntityInfo> entityInfos;
    Map<String, String> dummyResults;
    ResultIterator<Object> iterator;
    AdvancedCache<String, String> cache;
    private KeyTransformationHandler keyTransformationHandler;

    @BeforeMethod
    public void setUp() throws Exception {
        this.keys = new ArrayList<String>();
        this.dummyResults = new HashMap<String, String>();
        this.entityInfos = new ArrayList<EntityInfo>();
        this.keyTransformationHandler = new KeyTransformationHandler();
        for (int i = 1; i <= 10; ++i) {
            String key = "key" + i;
            this.keys.add(key);
            this.entityInfos.add(new MockEntityInfo(this.keyTransformationHandler.keyToString((Object)key)));
            this.dummyResults.put(key, "Result number " + i);
        }
        this.cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        Mockito.when((Object)this.cache.get(ArgumentMatchers.any())).thenAnswer(invocation -> {
            String k = invocation.getArguments()[0].toString();
            return this.dummyResults.get(k);
        });
        this.iterator = new EagerIterator(this.entityInfos, (QueryResultLoader)new EntityLoader(this.cache, this.keyTransformationHandler), this.getFetchSize());
    }

    protected int getFetchSize() {
        return 1;
    }

    @AfterMethod
    public void tearDown() {
        this.iterator.close();
        this.keys = null;
        this.dummyResults = null;
        this.iterator = null;
    }

    protected String resultAt(int index) {
        return this.dummyResults.get(this.keys.get(index));
    }

    public void testNextAndHasNext() {
        for (int i = 0; i < this.keys.size(); ++i) {
            String expectedValue = this.resultAt(i);
            assert (this.iterator.hasNext());
            assert (expectedValue == this.iterator.next());
        }
        assert (!this.iterator.hasNext());
    }

    private static class MockEntityInfo
    implements EntityInfo {
        private final String key;

        public MockEntityInfo(String key) {
            this.key = key;
        }

        public Serializable getId() {
            return this.key;
        }

        public String getIdName() {
            return null;
        }

        public Object[] getProjection() {
            return new Object[0];
        }

        public Object getEntityInstance() {
            return null;
        }

        public void populateWithEntityInstance(Object entity) {
        }

        public IndexedTypeIdentifier getType() {
            return null;
        }
    }
}

