/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.paritition;

import java.util.List;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.partitionhandling.SharedIndexTest")
public class SharedIndexTest
extends BasePartitionHandlingTest {
    protected int totalEntries = 100;

    public SharedIndexTest() {
        this.numMembersInCluster = 3;
        this.cacheMode = CacheMode.DIST_SYNC;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    protected ConfigurationBuilder cacheConfiguration() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.indexing().index(Index.PRIMARY_OWNER).addProperty("default.indexmanager", InfinispanIndexManager.class.getName());
        return configurationBuilder;
    }

    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.postConfigure(this.cacheManagers);
    }

    protected void postConfigure(List<EmbeddedCacheManager> cacheManagers) {
        ConfigurationBuilder replBuilder = new ConfigurationBuilder();
        replBuilder.clustering().cacheMode(CacheMode.REPL_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).indexing().index(Index.NONE);
        Configuration replConfig = replBuilder.build();
        ConfigurationBuilder distBuilder = new ConfigurationBuilder();
        distBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES).indexing().index(Index.NONE);
        Configuration distConfig = distBuilder.build();
        cacheManagers.forEach(cm -> {
            cm.defineConfiguration("LuceneIndexesLocking", replConfig);
            cm.defineConfiguration("LuceneIndexesData", distConfig);
            cm.defineConfiguration("LuceneIndexesMetadata", replConfig);
        });
    }

    @Test(expectedExceptions={AvailabilityException.class})
    public void shouldThrowExceptionInDegradedMode() {
        Cache cache = this.cache(0);
        IntStream.range(0, this.totalEntries).forEach(i -> {
            Person cfr_ignored_0 = (Person)cache.put((Object)i, (Object)new Person("Person " + i, "", i));
        });
        this.executeQueries();
        this.splitCluster(new int[][]{{0}, {1, 2}});
        this.partition(0).assertDegradedMode();
        this.executeQueries();
    }

    protected void assertAllNodesQueryResults(int results) {
        Assert.assertEquals((int)results, (int)this.totalEntries);
    }

    protected void assertSingleNodeQueryResults(int results) {
        Assert.assertTrue((results > 0 ? 1 : 0) != 0);
    }

    private void executeQueries() {
        String q = this.getQuery();
        this.caches().forEach(c -> {
            Query allNodesQuery = Search.getQueryFactory((Cache)c).create(q, this.getIndexedQueryMode());
            this.assertAllNodesQueryResults(allNodesQuery.getResultSize());
        });
        Query singleNodeQuery = Search.getQueryFactory((Cache)this.cache(0)).create(q);
        this.assertSingleNodeQueryResults(singleNodeQuery.list().size());
    }

    protected IndexedQueryMode getIndexedQueryMode() {
        return IndexedQueryMode.FETCH;
    }

    protected String getQuery() {
        return "From " + Person.class.getName() + " p where p.name:'person*'";
    }
}

