/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQCommandType;
import org.infinispan.query.impl.CustomQueryCommand;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.util.ByteString;

public final class ClusteredQueryCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    public static final byte COMMAND_ID = 101;
    private CQCommandType commandType;
    private QueryDefinition queryDefinition;
    private AdvancedCache<?, ?> cache;
    private UUID queryId;
    private int docIndex = 0;

    private ClusteredQueryCommand(CQCommandType commandType, String cacheName) {
        super(ByteString.fromString((String)cacheName));
        this.commandType = commandType;
    }

    public ClusteredQueryCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public void setCacheManager(EmbeddedCacheManager cm) {
        this.cache = cm.getCache(this.cacheName.toString()).getAdvancedCache();
    }

    static ClusteredQueryCommand createLazyIterator(QueryDefinition queryDefinition, Cache<?, ?> cache, UUID queryId) {
        ClusteredQueryCommand cmd = new ClusteredQueryCommand(CQCommandType.CREATE_LAZY_ITERATOR, cache.getName());
        cmd.queryDefinition = queryDefinition;
        cmd.queryId = queryId;
        return cmd;
    }

    static ClusteredQueryCommand getResultSize(QueryDefinition queryDefinition, Cache<?, ?> cache) {
        ClusteredQueryCommand cmd = new ClusteredQueryCommand(CQCommandType.GET_RESULT_SIZE, cache.getName());
        cmd.queryDefinition = queryDefinition;
        return cmd;
    }

    static ClusteredQueryCommand createEagerIterator(QueryDefinition queryDefinition, Cache<?, ?> cache) {
        ClusteredQueryCommand cmd = new ClusteredQueryCommand(CQCommandType.CREATE_EAGER_ITERATOR, cache.getName());
        cmd.queryDefinition = queryDefinition;
        return cmd;
    }

    static ClusteredQueryCommand destroyLazyQuery(Cache<?, ?> cache, UUID queryId) {
        ClusteredQueryCommand cmd = new ClusteredQueryCommand(CQCommandType.DESTROY_LAZY_ITERATOR, cache.getName());
        cmd.queryId = queryId;
        return cmd;
    }

    static ClusteredQueryCommand retrieveKeyFromLazyQuery(Cache<?, ?> cache, UUID queryId, int docIndex) {
        ClusteredQueryCommand cmd = new ClusteredQueryCommand(CQCommandType.GET_SOME_KEYS, cache.getName());
        cmd.queryId = queryId;
        cmd.docIndex = docIndex;
        return cmd;
    }

    public CompletableFuture<Object> invokeAsync() {
        return CompletableFuture.completedFuture(this.perform(this.cache));
    }

    public QueryResponse perform(AdvancedCache<?, ?> cache) {
        return this.commandType.perform(cache, this.queryDefinition, this.queryId, this.docIndex);
    }

    public byte getCommandId() {
        return 101;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum((Enum)this.commandType, (ObjectOutput)output);
        output.writeObject(this.queryDefinition);
        MarshallUtil.marshallUUID((UUID)this.queryId, (ObjectOutput)output, (boolean)true);
        output.writeInt(this.docIndex);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandType = (CQCommandType)MarshallUtil.unmarshallEnum((ObjectInput)input, CQCommandType::valueOf);
        this.queryDefinition = (QueryDefinition)input.readObject();
        this.queryId = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)true);
        this.docIndex = input.readInt();
    }

    public String toString() {
        return "ClusteredQueryCommand{cache=" + this.getCacheName() + '}';
    }

    public int hashCode() {
        int result = 31 + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        return 31 * result + (this.queryDefinition == null ? 0 : this.queryDefinition.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ClusteredQueryCommand.class) {
            return false;
        }
        ClusteredQueryCommand other = (ClusteredQueryCommand)obj;
        return (this.cacheName == null ? other.cacheName == null : this.cacheName.equals((Object)other.cacheName)) && (this.queryDefinition == null ? other.queryDefinition == null : this.queryDefinition.equals(other.queryDefinition));
    }

    public boolean isReturnValueExpected() {
        return true;
    }

    public boolean canBlock() {
        return true;
    }
}

