/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.NullFilteringResultIterator;
import org.infinispan.query.impl.PartitionHandlingSupport;
import org.infinispan.query.impl.ProjectionConverter;
import org.infinispan.query.impl.ProjectionLoader;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.QueryResultLoader;

public class CacheQueryImpl<E>
implements CacheQuery<E> {
    private static final FetchOptions DEFAULT_FETCH_OPTIONS = new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER);
    protected final AdvancedCache<?, ?> cache;
    protected final KeyTransformationHandler keyTransformationHandler;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected QueryDefinition queryDefinition;
    private ProjectionConverter projectionConverter;

    public CacheQueryImpl(Query luceneQuery, SearchIntegrator searchFactory, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, TimeoutExceptionFactory timeoutExceptionFactory, Class<?> ... classes) {
        this(timeoutExceptionFactory == null ? searchFactory.createHSQuery(luceneQuery, (Class[])classes) : searchFactory.createHSQuery(luceneQuery, (Class[])classes).timeoutExceptionFactory(timeoutExceptionFactory), cache, keyTransformationHandler);
    }

    public CacheQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.queryDefinition = queryDefinition;
        this.cache = cache;
        this.keyTransformationHandler = keyTransformationHandler;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
    }

    public CacheQueryImpl(HSQuery hSearchQuery, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this(new QueryDefinition(hSearchQuery), cache, keyTransformationHandler);
    }

    @Override
    public CacheQuery<E> filter(Filter filter) {
        this.queryDefinition.filter(filter);
        return this;
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        return this.queryDefinition.getHsQuery().queryResultSize();
    }

    @Override
    public CacheQuery<E> sort(Sort sort) {
        this.queryDefinition.setSort(sort);
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.queryDefinition.enableFullTextFilter(name);
    }

    @Override
    public CacheQuery<E> disableFullTextFilter(String name) {
        this.queryDefinition.disableFullTextFilter(name);
        return this;
    }

    @Override
    public CacheQuery<E> firstResult(int firstResult) {
        this.queryDefinition.setFirstResult(firstResult);
        return this;
    }

    @Override
    public CacheQuery<E> maxResults(int maxResults) {
        this.queryDefinition.setMaxResults(maxResults);
        return this;
    }

    @Override
    public ResultIterator<E> iterator() throws SearchException {
        return this.iterator(DEFAULT_FETCH_OPTIONS);
    }

    @Override
    public ResultIterator<E> iterator(FetchOptions fetchOptions) throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        HSQuery hSearchQuery = this.queryDefinition.getHsQuery();
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.EAGER) {
            hSearchQuery.getTimeoutManager().start();
            List entityInfos = hSearchQuery.queryEntityInfos();
            return this.filterNulls(new EagerIterator(entityInfos, this.getResultLoader(hSearchQuery), fetchOptions.getFetchSize()));
        }
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.LAZY) {
            DocumentExtractor extractor = hSearchQuery.queryDocumentExtractor();
            return this.filterNulls(new LazyIterator(extractor, this.getResultLoader(hSearchQuery), fetchOptions.getFetchSize()));
        }
        throw new IllegalArgumentException("Unknown FetchMode " + (Object)((Object)fetchOptions.getFetchMode()));
    }

    private ResultIterator<E> filterNulls(ResultIterator<E> iterator) {
        return new NullFilteringResultIterator<E>(iterator);
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        HSQuery hSearchQuery = this.queryDefinition.getHsQuery();
        hSearchQuery.getTimeoutManager().start();
        List entityInfos = hSearchQuery.queryEntityInfos();
        return this.getResultLoader(hSearchQuery).load(entityInfos);
    }

    private QueryResultLoader getResultLoader(HSQuery hSearchQuery) {
        EntityLoader entityLoader = new EntityLoader(this.cache, this.keyTransformationHandler);
        return hSearchQuery.getProjectedFields() == null ? entityLoader : new ProjectionLoader(this.projectionConverter, entityLoader);
    }

    @Override
    public FacetManager getFacetManager() {
        return this.queryDefinition.getHsQuery().getFacetManager();
    }

    @Override
    public Explanation explain(int documentId) {
        return this.queryDefinition.getHsQuery().explain(documentId);
    }

    @Override
    public CacheQuery<Object[]> projection(String ... fields) {
        this.projectionConverter = new ProjectionConverter(fields, this.cache, this.keyTransformationHandler);
        this.queryDefinition.getHsQuery().projection(this.projectionConverter.getHSearchProjection());
        return this;
    }

    @Override
    public CacheQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.getHsQuery().getTimeoutManager().setTimeout(timeout, timeUnit);
        return this;
    }
}

