/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryEngine;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.SecurityActions;

public final class ComponentRegistryUtils {
    private ComponentRegistryUtils() {
    }

    private static <T> T getRequiredComponent(Cache<?, ?> cache, Class<T> clazz) {
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache());
        Object component = componentRegistry.getComponent(clazz, clazz.getName());
        if (component == null) {
            throw new IllegalStateException("Indexing was not enabled on cache " + cache.getName() + ". " + clazz.getName() + " not found in component registry");
        }
        return (T)component;
    }

    public static SearchIntegrator getSearchIntegrator(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, SearchIntegrator.class);
    }

    public static EmbeddedQueryEngine getEmbeddedQueryEngine(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, EmbeddedQueryEngine.class);
    }

    public static QueryInterceptor getQueryInterceptor(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getRequiredComponent(cache, QueryInterceptor.class);
    }

    public static QueryCache getQueryCache(Cache<?, ?> cache) {
        return (QueryCache)SecurityActions.getCacheGlobalComponentRegistry(cache.getAdvancedCache()).getComponent(QueryCache.class);
    }
}

