/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.affinity.ShardAllocationManagerImpl;
import org.infinispan.query.affinity.ShardAllocatorManager;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.backend.TxQueryInterceptor;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.QueryBox;
import org.infinispan.query.continuous.impl.ContinuousQueryResult;
import org.infinispan.query.continuous.impl.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryEngine;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchPropertyHelper;
import org.infinispan.query.dsl.embedded.impl.IckleCacheEventFilterConverter;
import org.infinispan.query.dsl.embedded.impl.IckleFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.CommandInitializer;
import org.infinispan.query.impl.DefaultSearchMappingProvider;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfo;
import org.infinispan.query.impl.QueryDefinition;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.externalizers.LuceneBooleanQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneBytesRefExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFieldDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneFuzzyQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneMatchAllQueryExternalizer;
import org.infinispan.query.impl.externalizers.LucenePrefixQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneScoreDocExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortExternalizer;
import org.infinispan.query.impl.externalizers.LuceneSortFieldExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTermQueryExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneTopFieldDocsExternalizer;
import org.infinispan.query.impl.externalizers.LuceneWildcardQueryExternalizer;
import org.infinispan.query.impl.massindex.DistributedExecutorMassIndexer;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private static final Object REMOVED_REGISTRY_COMPONENT = new Object();
    private MBeanServer mbeanServer;
    private String jmxDomain;

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName) || icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.QUERYABLE)) {
            boolean isIndexed = cfg.indexing().index().isEnabled();
            AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
            SearchIntegrator searchFactory = null;
            if (isIndexed) {
                log.registeringQueryInterceptor(cacheName);
                cr.registerComponent((Object)new ShardAllocationManagerImpl(), ShardAllocatorManager.class);
                searchFactory = this.getSearchFactory(cacheName, cfg.indexing(), cr);
                this.createQueryInterceptorIfNeeded(cr, cfg, searchFactory);
                this.addCacheDependencyIfNeeded(cacheName, cache.getCacheManager(), cfg.indexing());
                CommandInitializer initializer = (CommandInitializer)cr.getComponent(CommandInitializer.class);
                initializer.setCacheManager(cache.getCacheManager());
                cr.registerComponent((Object)new QueryBox(), QueryBox.class);
            }
            this.registerMatcher(cr, searchFactory);
            EmbeddedQueryEngine queryEngine = new EmbeddedQueryEngine(cache, isIndexed);
            cr.registerComponent((Object)queryEngine, EmbeddedQueryEngine.class);
        }
    }

    private void registerMatcher(ComponentRegistry cr, SearchIntegrator searchFactory) {
        ReflectionMatcher reflectionMatcher;
        ClassLoader classLoader = (ClassLoader)cr.getGlobalComponentRegistry().getComponent(ClassLoader.class);
        if (searchFactory == null) {
            reflectionMatcher = new ReflectionMatcher(classLoader);
        } else {
            ReflectionEntityNamesResolver entityNamesResolver = new ReflectionEntityNamesResolver(classLoader);
            reflectionMatcher = new ReflectionMatcher((ObjectPropertyHelper)new HibernateSearchPropertyHelper(searchFactory, (EntityNameResolver)entityNamesResolver));
        }
        cr.registerComponent((Object)reflectionMatcher, ReflectionMatcher.class);
    }

    private void addCacheDependencyIfNeeded(String cacheStarting, EmbeddedCacheManager cacheManager, IndexingConfiguration indexingConfiguration) {
        if (indexingConfiguration.indexedEntities().isEmpty()) {
            cacheManager.addCacheDependency(cacheStarting, "___query_known_classes");
        }
        if (IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingConfiguration.properties())) {
            String metadataCacheName = IndexPropertyInspector.getMetadataCacheName((Properties)indexingConfiguration.properties());
            String lockingCacheName = IndexPropertyInspector.getLockingCacheName((Properties)indexingConfiguration.properties());
            String dataCacheName = IndexPropertyInspector.getDataCacheName((Properties)indexingConfiguration.properties());
            if (!(cacheStarting.equals(metadataCacheName) || cacheStarting.equals(lockingCacheName) || cacheStarting.equals(dataCacheName))) {
                cacheManager.addCacheDependency(cacheStarting, metadataCacheName);
                cacheManager.addCacheDependency(cacheStarting, lockingCacheName);
                cacheManager.addCacheDependency(cacheStarting, dataCacheName);
            }
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, SearchIntegrator searchFactory) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor == null) {
            ConcurrentHashMap<GlobalTransaction, Map<Object, Object>> txOldValues = new ConcurrentHashMap<GlobalTransaction, Map<Object, Object>>();
            IndexModificationStrategy indexingStrategy = IndexModificationStrategy.configuredStrategy(searchFactory, cfg);
            queryInterceptor = new QueryInterceptor(searchFactory, indexingStrategy, txOldValues, (Cache)cr.getComponent(Cache.class));
            AsyncInterceptorChain ic = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            EntryWrappingInterceptor wrappingInterceptor = (EntryWrappingInterceptor)ic.findInterceptorExtending(EntryWrappingInterceptor.class);
            AsyncInterceptor lastLoadingInterceptor = ic.findInterceptorExtending(CacheLoaderInterceptor.class);
            if (lastLoadingInterceptor == null) {
                lastLoadingInterceptor = wrappingInterceptor;
            }
            InterceptorConfigurationBuilder queryInterceptorBuilder = builder.customInterceptors().addInterceptor();
            queryInterceptorBuilder.interceptor((AsyncInterceptor)queryInterceptor);
            queryInterceptorBuilder.after(lastLoadingInterceptor.getClass());
            if (ic != null) {
                ic.addInterceptorAfter((AsyncInterceptor)queryInterceptor, lastLoadingInterceptor.getClass());
                cr.registerComponent((Object)queryInterceptor, QueryInterceptor.class);
                cr.registerComponent((Object)queryInterceptor, ((Object)((Object)queryInterceptor)).getClass().getName(), true);
            }
            if (cfg.transaction().transactionMode().isTransactional()) {
                TxQueryInterceptor txQueryInterceptor = new TxQueryInterceptor(txOldValues, queryInterceptor);
                if (ic != null) {
                    ic.addInterceptorBefore((AsyncInterceptor)txQueryInterceptor, wrappingInterceptor.getClass());
                }
                InterceptorConfigurationBuilder txQueryInterceptorBuilder = builder.customInterceptors().addInterceptor();
                txQueryInterceptorBuilder.interceptor((AsyncInterceptor)txQueryInterceptor);
                txQueryInterceptorBuilder.before(wrappingInterceptor.getClass());
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        IndexingConfiguration indexingConfiguration = configuration.indexing();
        if (!indexingConfiguration.index().isEnabled()) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        SearchIntegrator searchFactory = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        if (!indexingConfiguration.indexedEntities().isEmpty()) {
            TypedProperties indexingProperties = indexingConfiguration.properties();
            if (IndexPropertyInspector.hasInfinispanDirectory((Properties)indexingProperties)) {
                String metadataCacheName = IndexPropertyInspector.getMetadataCacheName((Properties)indexingProperties);
                String lockingCacheName = IndexPropertyInspector.getLockingCacheName((Properties)indexingProperties);
                String dataCacheName = IndexPropertyInspector.getDataCacheName((Properties)indexingProperties);
                if (cacheName.equals(dataCacheName) && (cacheName.equals(metadataCacheName) || cacheName.equals(lockingCacheName))) {
                    Class[] indexedEntities = indexingConfiguration.indexedEntities().toArray(new Class[indexingConfiguration.indexedEntities().size()]);
                    searchFactory.addClasses(indexedEntities);
                    this.checkIndexableClasses(searchFactory, indexingConfiguration.indexedEntities());
                }
            } else {
                this.checkIndexableClasses(searchFactory, indexingConfiguration.indexedEntities());
            }
        }
        this.registerQueryMBeans(cr, configuration, searchFactory);
    }

    private void checkIndexableClasses(SearchIntegrator searchFactory, Set<Class<?>> indexedEntities) {
        for (Class<?> c : indexedEntities) {
            if (searchFactory.getIndexBinding((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(c)) != null) continue;
            throw log.classNotIndexable(c.getName());
        }
    }

    private void registerQueryMBeans(ComponentRegistry cr, Configuration cfg, SearchIntegrator sf) {
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        GlobalJmxStatisticsConfiguration jmxConfig = cr.getGlobalComponentRegistry().getGlobalConfiguration().globalJmxStatistics();
        this.mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
        String queryGroupName = this.getQueryGroupName(jmxConfig.cacheManagerName(), cache.getName());
        this.jmxDomain = JmxUtil.buildJmxDomain((String)jmxConfig.domain(), (MBeanServer)this.mbeanServer, (String)queryGroupName);
        InfinispanQueryStatisticsInfo stats = new InfinispanQueryStatisticsInfo(sf);
        stats.setStatisticsEnabled(cfg.jmxStatistics().enabled());
        try {
            ObjectName statsObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=Statistics");
            JmxUtil.registerMBean((Object)stats, (ObjectName)statsObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register query module statistics mbean", (Throwable)e);
        }
        ManageableComponentMetadata massIndexerCompMetadata = cr.getGlobalComponentRegistry().getComponentMetadataRepo().findComponentMetadata(MassIndexer.class).toManageableComponentMetadata();
        try {
            DistributedExecutorMassIndexer massIndexer = new DistributedExecutorMassIndexer(cache, sf);
            ResourceDMBean mbean = new ResourceDMBean((Object)massIndexer, massIndexerCompMetadata);
            ObjectName massIndexerObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=" + massIndexerCompMetadata.getJmxObjectName());
            JmxUtil.registerMBean((Object)mbean, (ObjectName)massIndexerObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create ", (Throwable)e);
        }
    }

    private String getQueryGroupName(String cacheManagerName, String cacheName) {
        return "type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        AsyncInterceptorChain interceptorChain = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        return interceptorChain != null && interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchIntegrator getSearchFactory(String cacheName, IndexingConfiguration indexingConfiguration, ComponentRegistry cr) {
        Object component = cr.getComponent(SearchIntegrator.class);
        SearchIntegrator searchFactory = null;
        if (component instanceof SearchIntegrator) {
            searchFactory = (SearchIntegrator)component;
        }
        if (searchFactory == null) {
            ClassLoader aggregatedClassLoader = this.makeAggregatedClassLoader(cr.getGlobalComponentRegistry().getGlobalConfiguration().classLoader());
            HashSet<ProgrammaticSearchMappingProvider> programmaticSearchMappingProviders = new HashSet<ProgrammaticSearchMappingProvider>(ServiceFinder.load(ProgrammaticSearchMappingProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader}));
            programmaticSearchMappingProviders.add(new DefaultSearchMappingProvider());
            Collection analyzerDefProviders = ServiceFinder.load(LuceneAnalysisDefinitionProvider.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
            SearchableCacheConfiguration config = new SearchableCacheConfiguration(indexingConfiguration.indexedEntities(), (Properties)indexingConfiguration.properties(), programmaticSearchMappingProviders, analyzerDefProviders, cr, aggregatedClassLoader);
            searchFactory = new SearchIntegratorBuilder().configuration((SearchConfiguration)config).buildSearchIntegrator();
            cr.registerComponent((Object)searchFactory, SearchIntegrator.class);
        }
        return searchFactory;
    }

    private ClassLoader makeAggregatedClassLoader(ClassLoader globalClassLoader) {
        LinkedHashSet<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
        if (globalClassLoader != null) {
            classLoaders.add(globalClassLoader);
        }
        classLoaders.add(ClassLoaderService.class.getClassLoader());
        classLoaders.add(this.getClass().getClassLoader());
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                classLoaders.add(tccl);
            }
        }
        catch (Exception tccl) {
            // empty catch block
        }
        try {
            ClassLoader syscl = ClassLoader.getSystemClassLoader();
            if (syscl != null) {
                classLoaders.add(syscl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AggregatedClassLoader(classLoaders);
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        Object searchFactoryIntegrator;
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor != null) {
            queryInterceptor.prepareForStopping();
        }
        if ((searchFactoryIntegrator = cr.getComponent(SearchIntegrator.class)) != null && searchFactoryIntegrator != REMOVED_REGISTRY_COMPONENT) {
            ((SearchIntegrator)searchFactoryIntegrator).close();
            cr.registerComponent(REMOVED_REGISTRY_COMPONENT, SearchIntegrator.class);
        }
        if (this.mbeanServer != null) {
            String cacheManagerName = cr.getGlobalComponentRegistry().getGlobalConfiguration().globalJmxStatistics().cacheManagerName();
            String queryMBeanFilter = this.jmxDomain + ":" + this.getQueryGroupName(cacheManagerName, cacheName) + ",*";
            JmxUtil.unregisterMBeans((String)queryMBeanFilter, (MBeanServer)this.mbeanServer);
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeQueryInterceptorFromConfiguration(cfg);
    }

    private void removeQueryInterceptorFromConfiguration(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.asyncInterceptor() instanceof QueryInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        QueryCache queryCache = new QueryCache();
        gcr.registerComponent((Object)queryCache, QueryCache.class);
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_AND_CONVERTER, new IckleFilterAndConverter.IckleFilterAndConverterExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new IckleFilterAndConverter.FilterResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CACHE_EVENT_FILTER_CONVERTER, new IckleCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResult.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_BOOLEAN, new LuceneBooleanQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_TERM, new LuceneTermQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TERM, new LuceneTermExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT, new LuceneSortExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SORT_FIELD, new LuceneSortFieldExternalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_TOPDOCS, new NodeTopDocs.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPDOCS, new LuceneTopDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_FIELD_SCORE_DOC, new LuceneFieldDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_SCORE_DOC, new LuceneScoreDocExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_TOPFIELDDOCS, new LuceneTopFieldDocsExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_MATCH_ALL, new LuceneMatchAllQueryExternalizer());
        externalizerMap.put(ExternalizerIds.INDEX_WORKER, new IndexWorker.Externalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_BYTES_REF, new LuceneBytesRefExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_PREFIX, new LucenePrefixQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_WILDCARD, new LuceneWildcardQueryExternalizer());
        externalizerMap.put(ExternalizerIds.LUCENE_QUERY_FUZZY, new LuceneFuzzyQueryExternalizer());
        externalizerMap.put(ExternalizerIds.QUERY_DEFINITION, new QueryDefinition.Externalizer());
        externalizerMap.put(ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE, new QueryResponse.Externalizer());
    }
}

