/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.IndexModificationStrategy;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.DefaultCacheInheritancePreventedTest")
public class DefaultCacheInheritancePreventedTest
extends AbstractInfinispanTest {
    @Test
    public void verifyIndexDisabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test-enbledInDefault.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), true, IndexModificationStrategy.ALL);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), true, IndexModificationStrategy.ALL);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("not-searchable"), false, null);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true, IndexModificationStrategy.ALL);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true, IndexModificationStrategy.LOCAL_ONLY);
            }
        });
    }

    @Test
    public void verifyIndexEnabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), false, null);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), false, null);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true, IndexModificationStrategy.ALL);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true, IndexModificationStrategy.LOCAL_ONLY);
            }
        });
    }

    private void assertIndexingEnabled(Cache<Object, Object> cache, boolean expected, IndexModificationStrategy expectedModificationMode) {
        SearchManager searchManager = null;
        try {
            searchManager = Search.getSearchManager(cache);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (expected && searchManager == null) {
            Assert.fail((String)("SearchManager not found but expected for cache " + cache.getName()));
        }
        if (!expected && searchManager != null) {
            Assert.fail((String)("SearchManager not expected but found for cache " + cache.getName()));
        }
        QueryInterceptor queryInterceptor = null;
        try {
            queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (expected && queryInterceptor == null) {
            Assert.fail((String)("QueryInterceptor not found but expected for cache " + cache.getName()));
        }
        if (!expected && queryInterceptor != null) {
            Assert.fail((String)("QueryInterceptor not expected but found for cache " + cache.getName()));
        }
        if (expected) {
            Assert.assertEquals((Object)queryInterceptor.getIndexModificationMode(), (Object)expectedModificationMode);
        }
    }
}

