/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.Transaction;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.SearchFactoryHandler;
import org.infinispan.query.backend.SecurityActions;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Deprecated
public final class QueryKnownClasses {
    private static final Log log = LogFactory.getLog(QueryKnownClasses.class);
    public static final String QUERY_KNOWN_CLASSES_CACHE_NAME = "___query_known_classes";
    private final Set<Class<?>> indexedEntities;
    private final String cacheName;
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;
    private volatile SearchFactoryHandler searchFactoryHandler;
    private volatile AdvancedCache<KeyValuePair<String, Class<?>>, Boolean> knownClassesCache;
    private volatile TransactionHelper transactionHelper;
    private final AtomicReference<Map<Class<?>, Boolean>> localCache;

    QueryKnownClasses(String cacheName, Set<Class<?>> indexedEntities) {
        this.indexedEntities = Collections.unmodifiableSet(new HashSet(indexedEntities));
        this.cacheName = cacheName;
        this.cacheManager = null;
        this.internalCacheRegistry = null;
        this.localCache = null;
    }

    @Deprecated
    QueryKnownClasses(String cacheName, EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.indexedEntities = null;
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
        this.internalCacheRegistry = internalCacheRegistry;
        this.localCache = new AtomicReference(Collections.emptyMap());
    }

    String getCacheName() {
        return this.cacheName;
    }

    boolean isAutodetectEnabled() {
        return this.indexedEntities == null;
    }

    void start(SearchFactoryHandler searchFactoryHandler) {
        if (this.indexedEntities != null) {
            throw new IllegalStateException("Cannot start internal cache unless we are in autodetect mode");
        }
        if (searchFactoryHandler == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        this.searchFactoryHandler = searchFactoryHandler;
        this.startInternalCache();
        this.knownClassesCache.addListener(searchFactoryHandler.getCacheListener(), key -> ((String)key.getKey()).equals(this.cacheName));
    }

    void stop() {
        if (this.knownClassesCache != null) {
            if (this.searchFactoryHandler != null) {
                this.knownClassesCache.removeListener(this.searchFactoryHandler.getCacheListener());
                this.searchFactoryHandler = null;
            }
            this.knownClassesCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Class<?>> keys() {
        if (this.indexedEntities != null) {
            return this.indexedEntities;
        }
        this.startInternalCache();
        HashSet<Class> result = new HashSet<Class>();
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            for (KeyValuePair key : this.knownClassesCache.keySet()) {
                if (!((String)key.getKey()).equals(this.cacheName)) continue;
                result.add((Class)key.getValue());
            }
            Object object = result;
            return object;
        }
        finally {
            this.transactionHelper.resume(tx);
        }
    }

    boolean containsKey(Class<?> clazz) {
        if (this.indexedEntities != null) {
            return this.indexedEntities.contains(clazz);
        }
        return this.localCache.get().containsKey(clazz);
    }

    Boolean get(Class<?> clazz) {
        if (this.indexedEntities != null) {
            return this.indexedEntities.contains(clazz);
        }
        return this.localCache.get().get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(Class<?> clazz, Boolean value) {
        if (this.indexedEntities != null) {
            throw new IllegalStateException("Autodetect mode is not enabled for cache " + this.cacheName);
        }
        if (value == null) {
            throw new IllegalArgumentException("Null values are not allowed");
        }
        this.startInternalCache();
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            this.knownClassesCache.put((Object)new KeyValuePair((Object)this.cacheName, clazz), (Object)value);
        }
        finally {
            this.transactionHelper.resume(tx);
        }
        this.localCacheInsert(clazz, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localCacheInsert(Class<?> key, Boolean value) {
        AtomicReference<Map<Class<?>, Boolean>> atomicReference = this.localCache;
        synchronized (atomicReference) {
            Map<Class<?>, Boolean> currentContent = this.localCache.get();
            int currentSize = currentContent.size();
            if (currentSize == 0) {
                this.localCache.lazySet(Collections.singletonMap(key, value));
            } else {
                HashMap updatedContent = new HashMap(currentSize + 1);
                updatedContent.putAll(currentContent);
                updatedContent.put(key, value);
                this.localCache.lazySet(Collections.unmodifiableMap(updatedContent));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternalCache() {
        if (this.knownClassesCache == null) {
            QueryKnownClasses queryKnownClasses = this;
            synchronized (queryKnownClasses) {
                if (this.knownClassesCache == null) {
                    this.internalCacheRegistry.registerInternalCache(QUERY_KNOWN_CLASSES_CACHE_NAME, this.getInternalCacheConfig(), EnumSet.of(InternalCacheRegistry.Flag.PERSISTENT));
                    Cache knownClassesCache = SecurityActions.getCache(this.cacheManager, QUERY_KNOWN_CLASSES_CACHE_NAME);
                    this.knownClassesCache = knownClassesCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.IGNORE_RETURN_VALUES});
                    this.transactionHelper = new TransactionHelper(this.knownClassesCache.getTransactionManager());
                }
            }
        }
    }

    private Configuration getInternalCacheConfig() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        CacheMode cacheMode = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration().isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        configurationBuilder.clustering().cacheMode(cacheMode);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(null).invocationBatching().enable();
        configurationBuilder.security().authorization().disable();
        return configurationBuilder.build();
    }

    public String toString() {
        return "QueryKnownClasses{cacheName='" + this.cacheName + "', isAutodetectEnabled=" + this.isAutodetectEnabled() + ", indexedEntities=" + this.indexedEntities + ", localCache=" + (this.localCache != null ? this.localCache.get() : null) + '}';
    }
}

