/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.exception.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.query.clustered.ClusteredQueryCommand;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;

final class ClusteredQueryInvoker {
    private final RpcManager rpcManager;
    private final AdvancedCache<?, ?> cache;
    private final Address myAddress;
    private final ExecutorService asyncExecutor;
    private final RpcOptions rpcOptions;

    ClusteredQueryInvoker(AdvancedCache<?, ?> cache, ExecutorService asyncExecutor) {
        this.cache = cache;
        this.asyncExecutor = asyncExecutor;
        this.rpcManager = cache.getRpcManager();
        this.myAddress = this.rpcManager.getAddress();
        this.rpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(10000L, TimeUnit.MILLISECONDS).build();
    }

    QueryResponse unicast(Address address, ClusteredQueryCommand clusteredQueryCommand) {
        if (address.equals(this.myAddress)) {
            Future<QueryResponse> localResponse = this.localInvoke(clusteredQueryCommand);
            try {
                return localResponse.get();
            }
            catch (InterruptedException e) {
                throw new SearchException("Interrupted while searching locally", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SearchException("Exception while searching locally", (Throwable)e);
            }
        }
        Map responses = this.rpcManager.invokeRemotely(Collections.singletonList(address), (ReplicableCommand)clusteredQueryCommand, this.rpcOptions);
        List<QueryResponse> queryResponses = this.cast(responses);
        return queryResponses.get(0);
    }

    List<QueryResponse> broadcast(ClusteredQueryCommand clusteredQueryCommand) {
        Future<QueryResponse> localResponse = this.localInvoke(clusteredQueryCommand);
        Map responses = this.rpcManager.invokeRemotely(null, (ReplicableCommand)clusteredQueryCommand, this.rpcOptions);
        List<QueryResponse> queryResponses = this.cast(responses);
        try {
            queryResponses.add(localResponse.get());
        }
        catch (InterruptedException e) {
            throw new SearchException("Interrupted while searching locally", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new SearchException("Exception while searching locally", (Throwable)e);
        }
        return queryResponses;
    }

    private Future<QueryResponse> localInvoke(ClusteredQueryCommand clusteredQuery) {
        return this.asyncExecutor.submit(() -> {
            try {
                return clusteredQuery.perform(this.cache);
            }
            catch (Throwable e) {
                throw new SearchException(e);
            }
        });
    }

    private List<QueryResponse> cast(Map<Address, Response> responses) {
        LinkedList<QueryResponse> queryResponses = new LinkedList<QueryResponse>();
        for (Response resp : responses.values()) {
            if (resp instanceof SuccessfulResponse) {
                QueryResponse response = (QueryResponse)((SuccessfulResponse)resp).getResponseValue();
                queryResponses.add(response);
                continue;
            }
            throw new SearchException("Unexpected response: " + resp);
        }
        return queryResponses;
    }
}

