/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.phrases;

import java.util.HashSet;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.test.Author;
import org.infinispan.query.test.Book;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.queries.phrases.EmbeddedQueryTest")
public class EmbeddedQueryTest
extends SingleCacheManagerTest {
    public EmbeddedQueryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testSimpleQuery() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"author#1", (Object)new Author("author1", "surname1"));
        this.cache.put((Object)"author#2", (Object)new Author("author2", "surname2"));
        this.cache.put((Object)"author#3", (Object)new Author("author3", "surname3"));
        AssertJUnit.assertEquals((int)3, (int)this.cache.size());
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Author.class).get();
        Query luceneQuery = queryBuilder.phrase().onField("name").sentence("author1").createQuery();
        CacheQuery query = searchManager.getQuery(luceneQuery, new Class[]{Author.class});
        List result = query.list();
        AssertJUnit.assertEquals((int)1, (int)result.size());
        AssertJUnit.assertEquals((String)"surname1", (String)((Author)result.get(0)).getSurname());
    }

    public void testEmbeddedQuery() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        Author a1 = new Author("author1", "surname1");
        Author a2 = new Author("author2", "surname2");
        Author a3 = new Author("author3", "surname3");
        HashSet<Author> aSet1 = new HashSet<Author>();
        aSet1.add(a1);
        aSet1.add(a2);
        HashSet<Author> aSet2 = new HashSet<Author>();
        aSet2.add(a1);
        aSet2.add(a3);
        HashSet<Author> aSet3 = new HashSet<Author>();
        Book book1 = new Book("Book1", "Some very interesting book", aSet1);
        Book book2 = new Book("Book2", "Not so interesting book", aSet2);
        Book book3 = new Book("Book3", "Book of unknown author", aSet3);
        this.cache.put((Object)"book#1", (Object)book1);
        this.cache.put((Object)"book#2", (Object)book2);
        this.cache.put((Object)"book#3", (Object)book3);
        AssertJUnit.assertEquals((int)3, (int)this.cache.size());
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Book.class).get();
        Query luceneQuery = queryBuilder.phrase().onField("authors.name").sentence("author1").createQuery();
        CacheQuery query = searchManager.getQuery(luceneQuery, new Class[]{Book.class});
        List result = query.list();
        AssertJUnit.assertEquals((int)2, (int)result.size());
        luceneQuery = queryBuilder.phrase().onField("description").sentence("interesting").createQuery();
        query = searchManager.getQuery(luceneQuery, new Class[]{Book.class});
        result = query.list();
        AssertJUnit.assertEquals((int)2, (int)result.size());
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().index(Index.ALL).addIndexedEntity(Book.class).addIndexedEntity(Author.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }
}

