/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.query.indexmanager.LuceneWorkConverter;
import org.infinispan.query.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IndexUpdateCommand
extends AbstractUpdateCommand {
    private static final Log log = (Log)LogFactory.getLog(IndexUpdateCommand.class, Log.class);
    public static final byte COMMAND_ID = 102;

    public IndexUpdateCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        IndexManager indexManager = this.searchFactory.getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        KeyTransformationHandler handler = this.queryInterceptor.getKeyTransformationHandler();
        List<LuceneWork> workToApply = LuceneWorkConverter.transformKeysToString(luceneWorks, handler);
        indexManager.performOperations(workToApply, null);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 102;
    }
}

