/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.query.affinity.BaseAffinityTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="query.AffinityTopologyChangeTest", timeOut=900000L)
public class AffinityTopologyChangeTest
extends BaseAffinityTest {
    private final AtomicInteger globalCounter = new AtomicInteger(0);
    private BaseAffinityTest.Node indexing1;
    private BaseAffinityTest.Node indexing2;
    private BaseAffinityTest.Node indexing3;
    private BaseAffinityTest.Node querying;

    @BeforeMethod
    public void prepare() {
        this.indexing1 = new BaseAffinityTest.IndexingNode(this, this.getIndexThreadsPerNode(), this.globalCounter);
        this.indexing2 = new BaseAffinityTest.IndexingNode(this, this.getIndexThreadsPerNode(), this.globalCounter);
        this.indexing3 = new BaseAffinityTest.IndexingNode(this, this.getIndexThreadsPerNode(), this.globalCounter);
        this.querying = new BaseAffinityTest.QueryingNode(this, this.getQueryThreadsPerNode(), this.globalCounter, BaseAffinityTest.QueryType.MATCH_ALL);
    }

    @AfterMethod
    public void after() {
        this.indexing3.kill();
        this.querying.kill();
        this.indexing2.kill();
        this.indexing1.kill();
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    protected void createCacheManagers() throws Throwable {
    }

    @Test
    public void testReadWriteUnderTopologyChanges() throws Exception {
        CompletableFuture<Void> f1 = this.indexing1.addToCluster().run();
        CompletableFuture<Void> f2 = this.indexing2.addToCluster().run();
        this.eventuallyEquals(2, () -> this.indexing2.cacheManager.getMembers().size());
        CompletableFuture<Void> f3 = this.indexing3.addToCluster().run();
        CompletableFuture<Void> f4 = this.querying.addToCluster().run();
        CompletableFuture.allOf(f1, f2, f3, f4).join();
        this.assertDocsIndexed(50000L);
    }
}

