/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalysisDefinitionSourceService;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.ErrorHandlerFactory;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.query.affinity.AffinityErrorHandler;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.affinity.AffinityShardIdentifierProvider;
import org.infinispan.query.backend.ClassLoaderServiceImpl;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.InfinispanLoopbackService;
import org.infinispan.query.impl.IndexPropertyInspector;
import org.infinispan.query.logging.Log;
import org.infinispan.query.spi.ProgrammaticSearchMappingProvider;
import org.infinispan.util.logging.LogFactory;

public final class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private static final String HSEARCH_PREFIX = "hibernate.search.";
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final Log log = (Log)LogFactory.getLog(SearchableCacheConfiguration.class, Log.class);
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final SearchMapping searchMapping;
    private final Map<Class<? extends Service>, Object> providedServices;
    private final ClassLoaderServiceImpl classLoaderService;
    private boolean hasAffinity;

    public SearchableCacheConfiguration(Set<Class<?>> indexedEntities, Properties properties, Collection<ProgrammaticSearchMappingProvider> programmaticSearchMappingProviders, Collection<LuceneAnalysisDefinitionProvider> analyzerDefProviders, ComponentRegistry cr, ClassLoader aggregatedClassLoader) {
        this.classLoaderService = new ClassLoaderServiceImpl(aggregatedClassLoader);
        this.properties = this.augmentProperties(properties);
        if (this.hasAffinity) {
            ErrorHandler configuredErrorHandler = ErrorHandlerFactory.createErrorHandler((SearchConfiguration)this);
            this.properties.put("hibernate.search.error_handler", new AffinityErrorHandler(configuredErrorHandler));
        }
        Cache cache = (Cache)cr.getComponent(Cache.class);
        boolean isInfinispanDirectoryInternalCache = false;
        if (IndexPropertyInspector.hasInfinispanDirectory(properties) && (cache.getName().equals(IndexPropertyInspector.getDataCacheName(properties)) || cache.getName().equals(IndexPropertyInspector.getMetadataCacheName(properties)) || cache.getName().equals(IndexPropertyInspector.getLockingCacheName(properties)))) {
            isInfinispanDirectoryInternalCache = true;
        }
        LuceneAnalysisDefinitionProvider analyzerDefProvider = analyzerDefProviders != null && !analyzerDefProviders.isEmpty() ? builder -> {
            for (LuceneAnalysisDefinitionProvider provider : analyzerDefProviders) {
                if (log.isDebugEnabled()) {
                    log.debugf("Loading LuceneAnalysisDefinitionProvider for cache %s from provider : %s", cache.getName(), provider.getClass().getName());
                }
                provider.register(builder);
            }
        } : null;
        HashMap<Class<LuceneAnalysisDefinitionSourceService>, InfinispanLoopbackService> services = new HashMap<Class<LuceneAnalysisDefinitionSourceService>, InfinispanLoopbackService>(3);
        InfinispanLoopbackService loopService = new InfinispanLoopbackService(cr, cache.getCacheManager(), analyzerDefProvider);
        services.put(ComponentRegistryService.class, loopService);
        services.put(CacheManagerService.class, loopService);
        services.put(LuceneAnalysisDefinitionSourceService.class, loopService);
        this.providedServices = Collections.unmodifiableMap(services);
        this.classes = new HashMap();
        if (!isInfinispanDirectoryInternalCache) {
            for (Class<?> c : indexedEntities) {
                if (log.isDebugEnabled()) {
                    log.debugf("Found configured class mapping for Hibernate Search: %s", c.getName());
                }
                this.classes.put(c.getName(), c);
            }
        }
        SearchMapping searchMapping = SearchMappingHelper.extractSearchMapping((SearchConfiguration)this);
        if (programmaticSearchMappingProviders != null && !programmaticSearchMappingProviders.isEmpty()) {
            if (searchMapping == null) {
                searchMapping = new SearchMapping();
            }
            for (ProgrammaticSearchMappingProvider provider : programmaticSearchMappingProviders) {
                if (log.isDebugEnabled()) {
                    log.debugf("Loading programmatic search mappings for cache %s from provider : %s", cache.getName(), provider.getClass().getName());
                }
                provider.defineMappings(cache, searchMapping);
            }
        }
        this.searchMapping = searchMapping;
        if (!isInfinispanDirectoryInternalCache && this.searchMapping != null) {
            for (Class c : this.searchMapping.getMappedEntities()) {
                if (log.isDebugEnabled()) {
                    log.debugf("Found programmatically configured class mapping for Hibernate Search: %s", c.getName());
                }
                this.classes.put(c.getName(), c);
            }
        }
    }

    public boolean isDeleteByTermEnforced() {
        return true;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public boolean isIdProvidedImplicit() {
        return true;
    }

    private Properties augmentProperties(Properties origin) {
        Properties target = new Properties();
        if (origin != null) {
            for (Map.Entry<Object, Object> entry : origin.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String && !key.toString().startsWith(HSEARCH_PREFIX)) {
                    key = HSEARCH_PREFIX + key.toString();
                }
                target.put(key, entry.getValue());
                if (!(key instanceof String) || !key.toString().endsWith("indexmanager") || !entry.getValue().equals(AffinityIndexManager.class.getName())) continue;
                target.put(key.toString().replace("indexmanager", SHARDING_STRATEGY), AffinityShardIdentifierProvider.class.getName());
                this.hasAffinity = true;
            }
        }
        target.putIfAbsent("hibernate.search.index_uninverting_allowed", Boolean.TRUE.toString());
        return target;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }
}

