/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class TransactionHelper {
    private static final Log log = (Log)LogFactory.getLog(TransactionHelper.class, Log.class);
    private final TransactionManager transactionManager;

    public TransactionHelper(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void resume(Transaction transaction) {
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw log.unableToResumeSuspendedTx(transaction, e);
            }
        }
    }

    public Transaction suspendTxIfExists() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            throw log.unableToSuspendTx(e);
        }
    }
}

