/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;
import org.infinispan.query.remote.client.impl.Externalizers;

@SerializeWith(value=Externalizers.QueryResponseExternalizer.class)
public final class QueryResponse
implements BaseQueryResponse {
    private int numResults;
    private int projectionSize;
    private List<WrappedMessage> results;
    private long totalResults;

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public int getProjectionSize() {
        return this.projectionSize;
    }

    public void setProjectionSize(int projectionSize) {
        this.projectionSize = projectionSize;
    }

    public List<WrappedMessage> getResults() {
        return this.results;
    }

    public void setResults(List<WrappedMessage> results) {
        this.results = results;
    }

    @Override
    public List<?> extractResults(SerializationContext serializationContext) throws IOException {
        ArrayList<Object> unwrappedResults;
        if (this.projectionSize > 0) {
            unwrappedResults = new ArrayList(this.results.size() / this.projectionSize);
            Iterator<WrappedMessage> it = this.results.iterator();
            while (it.hasNext()) {
                Object[] row = new Object[this.projectionSize];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = it.next().getValue();
                }
                unwrappedResults.add(row);
            }
        } else {
            unwrappedResults = new ArrayList<Object>(this.results.size());
            for (WrappedMessage r : this.results) {
                Object o = r.getValue();
                if (serializationContext != null && o instanceof byte[]) {
                    o = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)serializationContext, (byte[])((byte[])o));
                }
                unwrappedResults.add(o);
            }
        }
        return unwrappedResults;
    }

    @Override
    public long getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(long totalResults) {
        this.totalResults = totalResults;
    }

    static final class Marshaller
    implements MessageMarshaller<QueryResponse> {
        Marshaller() {
        }

        public QueryResponse readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            QueryResponse queryResponse = new QueryResponse();
            queryResponse.setNumResults(reader.readInt("numResults"));
            queryResponse.setProjectionSize(reader.readInt("projectionSize"));
            queryResponse.setResults((List)reader.readCollection("results", new ArrayList(), WrappedMessage.class));
            queryResponse.setTotalResults(reader.readLong("totalResults"));
            return queryResponse;
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, QueryResponse queryResponse) throws IOException {
            writer.writeInt("numResults", queryResponse.numResults);
            writer.writeInt("projectionSize", queryResponse.projectionSize);
            writer.writeCollection("results", (Collection)queryResponse.results, WrappedMessage.class);
            writer.writeLong("totalResults", queryResponse.totalResults);
        }

        public Class<QueryResponse> getJavaClass() {
            return QueryResponse.class;
        }

        public String getTypeName() {
            return "org.infinispan.query.remote.client.QueryResponse";
        }
    }
}

