/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client;

import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.query.remote.client.BaseProtoStreamMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class BaseProtoStreamMarshallerTest {
    @Test
    public void testBasicTypesAreMarshallable() throws Exception {
        this.roundtrip("a");
        this.roundtrip(Character.valueOf('a'));
        this.roundtrip(0);
        this.roundtrip(0L);
        this.roundtrip(0.0);
        this.roundtrip(Float.valueOf(0.0f));
        this.roundtrip((byte)0);
        this.roundtrip((short)0);
        this.roundtrip(true);
        this.roundtrip(new byte[0]);
    }

    private void roundtrip(Object in) throws Exception {
        BaseProtoStreamMarshaller marshaller = this.makeIstance();
        Assert.assertTrue((boolean)marshaller.isMarshallable(in));
        byte[] buffer = marshaller.objectToByteBuffer(in);
        Assert.assertNotNull((Object)buffer);
        Object out = marshaller.objectFromByteBuffer(buffer);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals(in.getClass(), out.getClass());
        if (in instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])in), (byte[])((byte[])out));
        } else {
            Assert.assertEquals((Object)in, (Object)out);
        }
    }

    private BaseProtoStreamMarshaller makeIstance() {
        return new BaseProtoStreamMarshaller(){
            private final SerializationContext serCtx = ProtobufUtil.newSerializationContext((Configuration)Configuration.builder().build());

            protected SerializationContext getSerializationContext() {
                return this.serCtx;
            }
        };
    }
}

