/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.logging.Log;

class WrappedMessageTagHandler
implements TagHandler {
    protected static final Log log = (Log)LogFactory.getLog(WrappedMessageTagHandler.class, Log.class);
    protected final ProtobufValueWrapper valueWrapper;
    protected final SerializationContext serCtx;
    protected GenericDescriptor descriptor;
    protected byte[] messageBytes;
    protected Number numericValue;
    protected String stringValue;

    WrappedMessageTagHandler(ProtobufValueWrapper valueWrapper, SerializationContext serCtx) {
        this.valueWrapper = valueWrapper;
        this.serCtx = serCtx;
    }

    public void onStart(GenericDescriptor descriptor) {
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object value) {
        switch (fieldNumber) {
            case 8: {
                this.stringValue = value != null ? value.toString() : null;
                break;
            }
            case 9: 
            case 10: {
                this.stringValue = (String)value;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                this.numericValue = (Number)value;
                break;
            }
            case 16: {
                String typeName = (String)value;
                this.descriptor = this.serCtx.getDescriptorByName(typeName);
                break;
            }
            case 19: {
                Integer typeId = (Integer)value;
                this.descriptor = this.serCtx.getDescriptorByTypeId(typeId);
                break;
            }
            case 17: {
                this.messageBytes = (byte[])value;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field : " + fieldNumber);
            }
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        throw new IllegalStateException("No nested message is expected");
    }

    public void onEnd() {
        if (this.messageBytes != null) {
            if (this.descriptor == null) {
                throw new IllegalStateException("Type name or type id is missing");
            }
            this.valueWrapper.setMessageDescriptor((Descriptor)this.descriptor);
        }
    }
}

