/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.HashMap;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.logging.Log;
import org.jboss.logging.Logger;

final class IndexingMetadataCreator
implements AnnotationMetadataCreator<IndexingMetadata, Descriptor> {
    private static final Log log = (Log)LogFactory.getLog(IndexingMetadataCreator.class, Log.class);

    IndexingMetadataCreator() {
    }

    public IndexingMetadata create(Descriptor descriptor, AnnotationElement.Annotation annotation) {
        String v;
        String indexName = (String)annotation.getAttributeValue("index").getValue();
        if (indexName.isEmpty()) {
            indexName = null;
        }
        String entityAnalyzer = null;
        AnnotationElement.Annotation entityAnalyzerAnnotation = (AnnotationElement.Annotation)descriptor.getAnnotations().get("Analyzer");
        if (entityAnalyzerAnnotation != null && !(v = (String)entityAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
            entityAnalyzer = v;
        }
        HashMap<String, FieldMapping> fields = new HashMap<String, FieldMapping>(descriptor.getFields().size());
        for (FieldDescriptor fd : descriptor.getFields()) {
            AnnotationElement.Annotation fieldLevelAnalyzerAnnotationAttribute;
            String fieldLevelAnalyzerAttribute;
            AnnotationElement.Annotation fieldAnnotation;
            String v2;
            String fieldLevelAnalyzer = null;
            AnnotationElement.Annotation fieldAnalyzerAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("Analyzer");
            if (fieldAnalyzerAnnotation != null && !(v2 = (String)fieldAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
                fieldLevelAnalyzer = v2;
            }
            boolean isSortable = false;
            AnnotationElement.Annotation sortableFieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("SortableField");
            if (sortableFieldAnnotation != null) {
                isSortable = true;
            }
            if ((fieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("Field")) == null) continue;
            String fieldName = fd.getName();
            String v3 = (String)fieldAnnotation.getAttributeValue("name").getValue();
            if (!v3.isEmpty()) {
                fieldName = v3;
            }
            AnnotationElement.Value indexAttribute = fieldAnnotation.getAttributeValue("index");
            boolean isIndexed = "Index.YES".equals(indexAttribute.getValue());
            AnnotationElement.Value boostAttribute = fieldAnnotation.getAttributeValue("boost");
            float fieldLevelBoost = ((Float)boostAttribute.getValue()).floatValue();
            AnnotationElement.Value analyzeAttribute = fieldAnnotation.getAttributeValue("analyze");
            boolean isAnalyzed = "Analyze.YES".equals(analyzeAttribute.getValue());
            AnnotationElement.Value storeAttribute = fieldAnnotation.getAttributeValue("store");
            boolean isStored = "Store.YES".equals(storeAttribute.getValue());
            AnnotationElement.Value indexNullAsAttribute = fieldAnnotation.getAttributeValue("indexNullAs");
            String indexNullAs = (String)indexNullAsAttribute.getValue();
            if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
                indexNullAs = null;
            }
            if ((fieldLevelAnalyzerAttribute = (String)(fieldLevelAnalyzerAnnotationAttribute = (AnnotationElement.Annotation)fieldAnnotation.getAttributeValue("analyzer").getValue()).getAttributeValue("definition").getValue()).isEmpty()) {
                fieldLevelAnalyzerAttribute = null;
            } else {
                fieldLevelAnalyzer = fieldLevelAnalyzerAttribute;
            }
            if (!(isAnalyzed || fieldLevelAnalyzer == null && fieldLevelAnalyzerAttribute == null)) {
                throw new IllegalStateException("Cannot specify an analyzer for field " + fd.getFullName() + " unless the field is analyzed.");
            }
            LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Field.Index.toIndex((boolean)isIndexed, (boolean)isAnalyzed), Field.TermVector.NO, isStored ? Store.YES : Store.NO, indexNullAs, fieldLevelBoost, 1.0f);
            FieldMapping fieldMapping = new FieldMapping(fieldName, isIndexed, fieldLevelBoost, isAnalyzed, isStored, isSortable, fieldLevelAnalyzer, indexNullAs, (LuceneOptions)luceneOptions, fd);
            fields.put(fieldName, fieldMapping);
            if (!log.isEnabled(Logger.Level.DEBUG)) continue;
            log.debugf("fieldName=%s fieldMapping=%s", fieldName, fieldMapping);
        }
        IndexingMetadata indexingMetadata = new IndexingMetadata(true, indexName, entityAnalyzer, fields);
        if (log.isEnabled(Logger.Level.DEBUG)) {
            log.debugf("Descriptor name=%s indexingMetadata=%s", descriptor.getFullName(), indexingMetadata);
        }
        return indexingMetadata;
    }
}

