/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.indexing.ProtobufWrapperIndexingTest")
public class ProtobufWrapperIndexingTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testIndexingWithWrapper() throws Exception {
        SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContext((EmbeddedCacheManager)this.cacheManager);
        MarshallerRegistration.registerMarshallers((SerializationContext)serCtx);
        byte[] value1 = this.createMarshalledUser(serCtx, "Adrian", "Nistor");
        byte[] value2 = this.createMarshalledUser(serCtx, "John", "Batman");
        this.cache.put((Object)new byte[]{1, 2, 3}, (Object)value1);
        this.cache.put((Object)new byte[]{4, 5, 6}, (Object)value2);
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        SearchIntegrator searchFactory = (SearchIntegrator)sm.unwrap(SearchIntegrator.class);
        AssertJUnit.assertNotNull((Object)searchFactory.getIndexManager(ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName())));
        Query luceneQuery2 = ((TermMatchingContext)((TermMatchingContext)searchFactory.buildQueryBuilder().forEntity(ProtobufValueWrapper.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Adrian").createQuery();
        List queryEntityInfos = searchFactory.createHSQuery(luceneQuery2, new Class[]{ProtobufValueWrapper.class}).projection(new String[]{"surname"}).queryEntityInfos();
        AssertJUnit.assertEquals((int)1, (int)queryEntityInfos.size());
        EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(0);
        AssertJUnit.assertEquals((Object)"Nistor", (Object)entityInfo.getProjection()[0]);
    }

    private byte[] createMarshalledUser(SerializationContext serCtx, String name, String surname) throws IOException {
        User user = new User();
        user.setId(1);
        user.setName(name);
        user.setSurname(surname);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)serCtx, (Object)user);
    }
}

