/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.TestDomainSCI;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.indexing.ProtobufValueWrapperIndexingTest")
public class ProtobufValueWrapperIndexingTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).memory().encoding().value().mediaType("application/x-protostream").indexing().enable().addIndexedEntity("sample_bank_account.User").addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)TestDomainSCI.INSTANCE);
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)cfg);
    }

    public void testIndexingWithWrapper() throws Exception {
        SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContext((EmbeddedCacheManager)this.cacheManager);
        MarshallerRegistration.registerMarshallers((SerializationContext)serCtx);
        this.cache.put((Object)new byte[]{1, 2, 3}, (Object)this.createUser("Adrian", "Nistor"));
        this.cache.put((Object)new byte[]{4, 5, 6}, (Object)this.createUser("John", "Batman"));
        SearchIntegrator searchFactory = (SearchIntegrator)TestingUtil.extractComponent((Cache)this.cache, SearchIntegrator.class);
        AssertJUnit.assertNotNull((Object)searchFactory.getIndexManager(ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName())));
        Query luceneQuery2 = ((TermMatchingContext)((TermMatchingContext)searchFactory.buildQueryBuilder().forEntity(ProtobufValueWrapper.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Adrian").createQuery();
        List queryEntityInfos = searchFactory.createHSQuery(luceneQuery2, new Class[]{ProtobufValueWrapper.class}).projection(new String[]{"surname"}).queryEntityInfos();
        AssertJUnit.assertEquals((int)1, (int)queryEntityInfos.size());
        EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(0);
        AssertJUnit.assertEquals((Object)"Nistor", (Object)entityInfo.getProjection()[0]);
    }

    private User createUser(String name, String surname) {
        User user = new User();
        user.setId(1);
        user.setName(name);
        user.setSurname(surname);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }
}

