/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

public final class ProtobufValueWrapperIndexingInterceptor
implements EntityIndexingInterceptor<ProtobufValueWrapper> {
    public IndexingOverride onAdd(ProtobufValueWrapper entity) {
        return this.isIndexed(entity) ? IndexingOverride.APPLY_DEFAULT : IndexingOverride.SKIP;
    }

    public IndexingOverride onUpdate(ProtobufValueWrapper entity) {
        return this.isIndexed(entity) ? IndexingOverride.APPLY_DEFAULT : IndexingOverride.SKIP;
    }

    public IndexingOverride onDelete(ProtobufValueWrapper entity) {
        return IndexingOverride.APPLY_DEFAULT;
    }

    public IndexingOverride onCollectionUpdate(ProtobufValueWrapper entity) {
        return this.isIndexed(entity) ? IndexingOverride.APPLY_DEFAULT : IndexingOverride.SKIP;
    }

    private boolean isIndexed(ProtobufValueWrapper entity) {
        if (entity == null) {
            return false;
        }
        Descriptor messageDescriptor = entity.getMessageDescriptor();
        if (messageDescriptor == null) {
            return false;
        }
        IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
        return indexingMetadata != null && indexingMetadata.isIndexed();
    }
}

