/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.impl.ProtobufFieldIndexingMetadata;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufFieldIndexingMetadataTest")
public class ProtobufFieldIndexingMetadataTest
extends SingleCacheManagerTest {
    private static final String PROTO_DEFINITIONS = "/** @Indexed */ message User {\n\n   /** @Field(store = Store.YES) */ required string name = 1;\n\n   required string surname = 2;\n\n   /** @Indexed */   message Address {\n      /** @Field(store = Store.YES) */ required string street = 10;\n      required string postCode = 20;\n   }\n\n   /** @Field(store = Store.YES) */ repeated Address indexedAddresses = 3;\n\n   /** @Field(index = Index.NO) */ repeated Address unindexedAddresses = 4;\n}";

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testProtobufFieldIndexingMetadata() {
        SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContext((EmbeddedCacheManager)this.cacheManager);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"user_definition.proto", (String)PROTO_DEFINITIONS));
        ProtobufFieldIndexingMetadata userIndexedFieldProvider = new ProtobufFieldIndexingMetadata(serCtx.getMessageDescriptor("User"));
        ProtobufFieldIndexingMetadata addressIndexedFieldProvider = new ProtobufFieldIndexingMetadata(serCtx.getMessageDescriptor("User.Address"));
        AssertJUnit.assertTrue((boolean)userIndexedFieldProvider.isIndexed(new String[]{"name"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"surname"}));
        AssertJUnit.assertTrue((boolean)addressIndexedFieldProvider.isIndexed(new String[]{"street"}));
        AssertJUnit.assertFalse((boolean)addressIndexedFieldProvider.isIndexed(new String[]{"postCode"}));
        AssertJUnit.assertTrue((boolean)userIndexedFieldProvider.isIndexed(new String[]{"indexedAddresses", "street"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"indexedAddresses", "postCode"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"unindexedAddresses", "street"}));
        AssertJUnit.assertFalse((boolean)userIndexedFieldProvider.isIndexed(new String[]{"unindexedAddresses", "postCode"}));
    }

    @Test(expectedExceptions={DescriptorParserException.class}, expectedExceptionsMessageRegExp="java.lang.IllegalStateException: Cannot specify an analyzer for field test.User3.name unless the field is analyzed.")
    public void testAnalyzerForNotAnalyzedField() {
        String testProto = "package test;\n/* @Indexed */ message User3 {\n   /* @Field(store=Store.NO, index=Index.YES, analyze=Analyze.NO, analyzer=@Analyzer(definition=\"standard\")) */   required string name = 1;\n}";
        SerializationContext serCtx = ProtobufMetadataManagerImpl.getSerializationContext((EmbeddedCacheManager)this.cacheManager);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"test2.proto", (String)testProto));
    }
}

