/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.io.Serializable;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

public final class ProtobufValueWrapperSearchWorkCreator
implements SearchWorkCreator {
    private final SearchWorkCreator delegate;
    private final SerializationContext serializationContext;
    private final Descriptor wrapperDescriptor;

    public ProtobufValueWrapperSearchWorkCreator(SearchWorkCreator searchWorkCreator, SerializationContext serializationContext) {
        if (searchWorkCreator == null) {
            throw new IllegalArgumentException("searchWorkCreator argument cannot be null");
        }
        this.delegate = searchWorkCreator;
        this.serializationContext = serializationContext;
        this.wrapperDescriptor = serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
    }

    public Work createPerEntityWork(Object entity, Serializable id, WorkType workType) {
        if (entity instanceof ProtobufValueWrapper) {
            this.discoverMessageType((ProtobufValueWrapper)entity);
        }
        return this.delegate.createPerEntityWork(entity, id, workType);
    }

    public Work createPerEntityTypeWork(IndexedTypeIdentifier entityType, WorkType workType) {
        return this.delegate.createPerEntityTypeWork(entityType, workType);
    }

    public Work createPerEntityWork(Serializable id, IndexedTypeIdentifier entityType, WorkType workType) {
        return this.delegate.createPerEntityWork(id, entityType, workType);
    }

    private void discoverMessageType(ProtobufValueWrapper valueWrapper) {
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new WrappedMessageTagHandler(valueWrapper, this.serializationContext), this.wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

