/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufMetadataCachePreserveStateAcrossRestartsTest")
public class ProtobufMetadataCachePreserveStateAcrossRestartsTest
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager createCacheManager(String persistentStateLocation) throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().clusteredDefault();
        global.globalState().enable().persistentLocation(persistentStateLocation);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cacheManager.getCache();
        return cacheManager;
    }

    public void testStatePreserved() throws Exception {
        String persistentStateLocation = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)persistentStateLocation);
        String persistentStateLocation1 = persistentStateLocation + "/1";
        String persistentStateLocation2 = persistentStateLocation + "/2";
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.createCacheManager(persistentStateLocation1), this.createCacheManager(persistentStateLocation2)}){

            public void call() {
                Cache protobufMetadaCache = this.cms[0].getCache("___protobuf_metadata");
                protobufMetadaCache.put((Object)"testA.proto", (Object)"package A;");
                protobufMetadaCache.put((Object)"testB.proto", (Object)"import \"testB.proto\";\npackage B;");
            }
        });
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.createCacheManager(persistentStateLocation1), this.createCacheManager(persistentStateLocation2)}){

            public void call() {
                Cache protobufMetadaCache = this.cms[0].getCache("___protobuf_metadata");
                AssertJUnit.assertTrue((boolean)protobufMetadaCache.containsKey((Object)"testA.proto"));
                AssertJUnit.assertTrue((boolean)protobufMetadaCache.containsKey((Object)"testB.proto"));
                AssertJUnit.assertTrue((boolean)protobufMetadaCache.containsKey((Object)"testB.proto.errors"));
            }
        });
    }
}

