/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufMetadataCachePreserveStateAcrossRestartsTest")
public class ProtobufMetadataCachePreserveStateAcrossRestartsTest
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager createCacheManager(String persistentStateLocation) throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().clusteredDefault();
        global.globalState().enable().persistentLocation(persistentStateLocation);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cacheManager.getCache();
        return cacheManager;
    }

    public void testStatePreserved1Node() throws Exception {
        String persistentStateLocation = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)persistentStateLocation);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() {
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.insertSchemas(this.cm);
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cm);
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() {
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cm);
            }
        });
    }

    public void testStatePreserved2Nodes() throws Exception {
        String persistentStateLocation = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)persistentStateLocation);
        String persistentStateLocation1 = persistentStateLocation + "/1";
        String persistentStateLocation2 = persistentStateLocation + "/2";
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.createCacheManager(persistentStateLocation1), this.createCacheManager(persistentStateLocation2)}){

            public void call() {
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.insertSchemas(this.cms[0]);
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cms[0]);
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cms[1]);
            }
        });
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.createCacheManager(persistentStateLocation1), this.createCacheManager(persistentStateLocation2)}){

            public void call() {
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cms[0]);
                ProtobufMetadataCachePreserveStateAcrossRestartsTest.this.verifySchemas((CacheContainer)this.cms[0]);
            }
        });
    }

    private void insertSchemas(EmbeddedCacheManager cm) {
        Cache protobufMetadaCache = cm.getCache("___protobuf_metadata");
        protobufMetadaCache.put((Object)"D.proto", (Object)"import \"B.proto\";\nimport \"C.proto\";\npackage D;\nmessage M {\nrequired string s = 1;\n}");
        this.assertFilesWithErrors((CacheContainer)cm, "D.proto");
        protobufMetadaCache.put((Object)"C.proto", (Object)"import \"A.proto\";\nimport \"B.proto\";\npackage C;");
        this.assertFilesWithErrors((CacheContainer)cm, "D.proto", "C.proto");
        protobufMetadaCache.put((Object)"B.proto", (Object)"import \"A.proto\";\npackage B;");
        this.assertFilesWithErrors((CacheContainer)cm, "D.proto", "C.proto", "B.proto");
        protobufMetadaCache.put((Object)"A.proto", (Object)"package A;");
        this.assertFilesWithErrors((CacheContainer)cm, new String[0]);
        protobufMetadaCache.put((Object)"E.proto", (Object)"import \"E.proto\";\npackage E;");
        protobufMetadaCache.put((Object)"F.proto", (Object)"import \"E.proto\";\nimport \"X.proto\";\npackage E;");
        this.assertFilesWithErrors((CacheContainer)cm, "E.proto", "F.proto");
    }

    private void verifySchemas(CacheContainer manager) {
        this.assertFiles(manager, "A.proto", "B.proto", "C.proto", "D.proto", "E.proto", "F.proto");
        this.assertFilesWithErrors(manager, "E.proto", "F.proto");
        SerializationContextRegistry scr = (SerializationContextRegistry)TestingUtil.extractGlobalComponent((CacheContainer)manager, SerializationContextRegistry.class);
        ImmutableSerializationContext serializationContext = scr.getUserCtx();
        Descriptor mDescriptor = serializationContext.getMessageDescriptor("D.M");
        AssertJUnit.assertNotNull((Object)mDescriptor);
        List fields = mDescriptor.getFields().stream().map(AnnotatedDescriptorImpl::getName).collect(Collectors.toList());
        AssertJUnit.assertEquals(Collections.singletonList("s"), fields);
    }

    private void assertFilesWithErrors(CacheContainer manager, String ... expectedFileNames) {
        ProtobufMetadataManager pmm = (ProtobufMetadataManager)TestingUtil.extractGlobalComponent((CacheContainer)manager, ProtobufMetadataManager.class);
        AssertJUnit.assertEquals((Object)TestingUtil.setOf((Object[])expectedFileNames), (Object)TestingUtil.setOf((Object[])pmm.getFilesWithErrors()));
        for (String fileName : expectedFileNames) {
            AssertJUnit.assertNotNull((Object)pmm.getFileErrors(fileName));
        }
    }

    private void assertFiles(CacheContainer manager, String ... expectedFileNames) {
        ProtobufMetadataManager pmm = (ProtobufMetadataManager)TestingUtil.extractGlobalComponent((CacheContainer)manager, ProtobufMetadataManager.class);
        AssertJUnit.assertEquals((Object)TestingUtil.setOf((Object[])expectedFileNames), (Object)TestingUtil.setOf((Object[])pmm.getProtofileNames()));
    }
}

