/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.impl.indexing.TestDomainSCI;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.indexing.ProtobufValueWrapperIndexingTest")
public class ProtobufValueWrapperIndexingTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).memory().encoding().value().mediaType("application/x-protostream").indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User");
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.serialization().addContextInitializer((SerializationContextInitializer)TestDomainSCI.INSTANCE);
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)cfg);
    }

    public void testIndexingWithWrapper() {
        SearchMapping searchMapping = ComponentRegistryUtils.getSearchMapping((Cache)this.cache);
        AssertJUnit.assertNotNull((Object)searchMapping);
        this.cache.put((Object)new byte[]{1, 2, 3}, (Object)this.createUser("Adrian", "Nistor"));
        this.cache.put((Object)new byte[]{4, 5, 6}, (Object)this.createUser("John", "Batman"));
        SearchSession session = searchMapping.getMappingSession();
        SearchScope scope = session.scope(byte[].class, "sample_bank_account.User");
        SearchQuery query = session.search(scope).select(f -> f.field("surname")).where(f -> f.match().field("name").matching((Object)"Adrian")).toQuery();
        List result = query.fetchAllHits();
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((Object)"Nistor", result.get(0));
    }

    private User createUser(String name, String surname) {
        User user = new User();
        user.setId(1);
        user.setName(name);
        user.setSurname(surname);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }
}

