/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMessageContext;
import org.infinispan.query.remote.impl.mapping.reference.IndexReferenceHolder;

public final class IndexingTagHandler
implements TagHandler {
    private final IndexReferenceHolder indexReferenceHolder;
    private IndexingMessageContext messageContext;

    public IndexingTagHandler(Descriptor messageDescriptor, DocumentElement document, IndexReferenceHolder indexReferenceHolder) {
        this.indexReferenceHolder = indexReferenceHolder;
        this.messageContext = new IndexingMessageContext(null, null, messageDescriptor, document);
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        this.messageContext.markField(fieldNumber);
        if (fieldDescriptor != null) {
            this.addFieldToDocument(fieldDescriptor, tagValue);
        }
    }

    private void addFieldToDocument(FieldDescriptor fieldDescriptor, Object value) {
        Object fieldPath = this.messageContext.getFieldPath();
        fieldPath = fieldPath != null ? (String)fieldPath + "." + fieldDescriptor.getName() : fieldDescriptor.getName();
        IndexFieldReference<?> fieldReference = this.indexReferenceHolder.getFieldReference((String)fieldPath);
        if (fieldReference != null) {
            this.messageContext.addValue(fieldReference, value);
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.messageContext.markField(fieldNumber);
        this.pushContext(fieldDescriptor, fieldDescriptor.getMessageType());
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFields();
    }

    private void pushContext(FieldDescriptor fieldDescriptor, Descriptor messageDescriptor) {
        IndexObjectFieldReference objectReference;
        String fieldPath = this.messageContext.getFieldPath();
        fieldPath = fieldPath != null ? fieldPath + "." + fieldDescriptor.getName() : fieldDescriptor.getName();
        DocumentElement documentElement = null;
        if (this.messageContext.getDocument() != null && (objectReference = this.indexReferenceHolder.getObjectReference(fieldPath)) != null) {
            documentElement = this.messageContext.getDocument().addObject(objectReference);
        }
        this.messageContext = new IndexingMessageContext(this.messageContext, fieldDescriptor, messageDescriptor, documentElement);
    }

    private void popContext() {
        this.indexMissingFields();
        this.messageContext = (IndexingMessageContext)this.messageContext.getParentContext();
    }

    private void indexMissingFields() {
        if (this.messageContext.getDocument() == null) {
            return;
        }
        for (FieldDescriptor fieldDescriptor : this.messageContext.getMessageDescriptor().getFields()) {
            if (this.messageContext.isFieldMarked(fieldDescriptor.getNumber())) continue;
            Object defaultValue = fieldDescriptor.hasDefaultValue() ? fieldDescriptor.getDefaultValue() : null;
            this.addFieldToDocument(fieldDescriptor, defaultValue);
        }
    }
}

