/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.remote.ExternalizerIds;
import org.infinispan.query.remote.indexing.ProtobufValueWrapperFieldBridge;

@Indexed
@ClassBridge(norms=Norms.NO, store=Store.YES, analyze=Analyze.YES, impl=ProtobufValueWrapperFieldBridge.class)
public final class ProtobufValueWrapper {
    private final byte[] binary;

    public ProtobufValueWrapper(byte[] binary) {
        this.binary = binary;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufValueWrapper that = (ProtobufValueWrapper)o;
        return Arrays.equals(this.binary, that.binary);
    }

    public int hashCode() {
        return Arrays.hashCode(this.binary);
    }

    public String toString() {
        return "ProtobufValueWrapper(" + Arrays.toString(this.binary) + ')';
    }

    public static final class Externalizer
    extends AbstractExternalizer<ProtobufValueWrapper> {
        public void writeObject(ObjectOutput output, ProtobufValueWrapper protobufValueWrapper) throws IOException {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)protobufValueWrapper.getBinary().length);
            output.write(protobufValueWrapper.getBinary());
        }

        public ProtobufValueWrapper readObject(ObjectInput input) throws IOException {
            int length = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            byte[] binary = new byte[length];
            input.readFully(binary);
            return new ProtobufValueWrapper(binary);
        }

        public Integer getId() {
            return ExternalizerIds.PROTOBUF_VALUE_WRAPPER;
        }

        public Set<Class<? extends ProtobufValueWrapper>> getTypeClasses() {
            return Collections.singleton(ProtobufValueWrapper.class);
        }
    }
}

