/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.query.remote.SerializationContextHolder;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.indexing.WrappedMessageTagHandler;

public final class ProtobufValueWrapperFieldBridge
implements FieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (!(value instanceof ProtobufValueWrapper)) {
            throw new IllegalArgumentException("This FieldBridge can only be applied to a ProtobufValueWrapper");
        }
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)value;
        this.decodeAndIndex(valueWrapper.getBinary(), document, luceneOptions);
    }

    private void decodeAndIndex(byte[] bytes, Document document, LuceneOptions luceneOptions) {
        SerializationContext serCtx = SerializationContextHolder.getSerializationContext();
        Descriptors.Descriptor wrapperDescriptor = serCtx.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        try {
            new ProtobufParser().parse((TagHandler)new WrappedMessageTagHandler(document, luceneOptions, serCtx), wrapperDescriptor, bytes);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

