/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.search;

import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.infinispan.query.remote.search.IspnLucenePredicateFactory;

class IspnLuceneComparisonPredicate
extends ComparisonPredicate<Query> {
    private final QueryBuilder builder;

    public IspnLuceneComparisonPredicate(QueryBuilder builder, String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
        this.builder = builder;
    }

    protected Query getStrictlyLessQuery() {
        if (IspnLucenePredicateFactory.isNumericValue(this.value)) {
            return NumericFieldUtils.createNumericRangeQuery((String)this.propertyName, null, (Object)this.value, (boolean)false, (boolean)false);
        }
        return ((RangeMatchingContext)this.builder.range().onField(this.propertyName).ignoreFieldBridge()).below(this.value).excludeLimit().createQuery();
    }

    protected Query getLessOrEqualsQuery() {
        if (IspnLucenePredicateFactory.isNumericValue(this.value)) {
            return NumericFieldUtils.createNumericRangeQuery((String)this.propertyName, null, (Object)this.value, (boolean)false, (boolean)true);
        }
        return ((RangeMatchingContext)this.builder.range().onField(this.propertyName).ignoreFieldBridge()).below(this.value).createQuery();
    }

    protected Query getEqualsQuery() {
        if (IspnLucenePredicateFactory.isNumericValue(this.value)) {
            return NumericFieldUtils.createExactMatchQuery((String)this.propertyName, (Object)this.value);
        }
        return ((TermMatchingContext)this.builder.keyword().onField(this.propertyName).ignoreFieldBridge()).matching(this.value).createQuery();
    }

    protected Query getGreaterOrEqualsQuery() {
        if (IspnLucenePredicateFactory.isNumericValue(this.value)) {
            return NumericFieldUtils.createNumericRangeQuery((String)this.propertyName, (Object)this.value, null, (boolean)true, (boolean)false);
        }
        return ((RangeMatchingContext)this.builder.range().onField(this.propertyName).ignoreFieldBridge()).above(this.value).createQuery();
    }

    protected Query getStrictlyGreaterQuery() {
        if (IspnLucenePredicateFactory.isNumericValue(this.value)) {
            return NumericFieldUtils.createNumericRangeQuery((String)this.propertyName, (Object)this.value, null, (boolean)false, (boolean)false);
        }
        return ((RangeMatchingContext)this.builder.range().onField(this.propertyName).ignoreFieldBridge()).above(this.value).excludeLimit().createQuery();
    }
}

