/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.indexing;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.indexing.ProtobufWrapperIndexingTest")
public class ProtobufWrapperIndexingTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testIndexingWithWrapper() throws Exception {
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtobufMetadataManager.getSerializationContext((EmbeddedCacheManager)this.cacheManager));
        ProtobufValueWrapper wrapper1 = new ProtobufValueWrapper(this.createMarshalledUser("Adrian", "Nistor"));
        ProtobufValueWrapper wrapper2 = new ProtobufValueWrapper(this.createMarshalledUser("John", "Batman"));
        this.cache.put((Object)1, (Object)wrapper1);
        this.cache.put((Object)2, (Object)wrapper2);
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        SearchIntegrator searchFactory = sm.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManager(ProtobufValueWrapper.class.getName()));
        Query luceneQuery = ((TermMatchingContext)((TermMatchingContext)sm.buildQueryBuilderForClass(ProtobufValueWrapper.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Adrian").createQuery();
        List list = sm.getQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)1L, (long)list.size());
        ProtobufValueWrapper pvw = (ProtobufValueWrapper)list.get(0);
        User unwrapped = (User)ProtobufUtil.fromWrappedByteArray((SerializationContext)ProtobufMetadataManager.getSerializationContextInternal((EmbeddedCacheManager)this.cacheManager), (byte[])pvw.getBinary());
        Assert.assertEquals((Object)"Adrian", (Object)unwrapped.getName());
        Query luceneQuery2 = ((TermMatchingContext)((TermMatchingContext)searchFactory.buildQueryBuilder().forEntity(ProtobufValueWrapper.class).get().keyword().onField("name").ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)"Adrian").createQuery();
        List queryEntityInfos = searchFactory.createHSQuery().luceneQuery(luceneQuery2).targetedEntities(Collections.singletonList(ProtobufValueWrapper.class)).projection(new String[]{"surname"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = (EntityInfo)queryEntityInfos.get(0);
        Assert.assertEquals((Object)"Nistor", (Object)entityInfo.getProjection()[0]);
    }

    private byte[] createMarshalledUser(String name, String surname) throws IOException {
        User user = new User();
        user.setId(1);
        user.setName(name);
        user.setSurname(surname);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return ProtobufUtil.toWrappedByteArray((SerializationContext)ProtobufMetadataManager.getSerializationContextInternal((EmbeddedCacheManager)this.cacheManager), (Object)user);
    }
}

