/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.indexing.IndexingMetadata;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.util.KeyValuePair;

public class QueryFacadeImpl
implements QueryFacade {
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        try {
            SerializationContext serCtx = ProtobufMetadataManager.getSerializationContextInternal(cache.getCacheManager());
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            QueryResponse response = cache.getCacheConfiguration().indexing().index().isEnabled() ? this.executeQuery(cache, serCtx, request) : this.executeNonIndexedQuery(cache, serCtx, request);
            return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
        }
        catch (IOException e) {
            throw new CacheException("An exception has occurred during query execution", (Throwable)e);
        }
    }

    private QueryResponse executeNonIndexedQuery(AdvancedCache<byte[], byte[]> cache, SerializationContext serCtx, QueryRequest request) throws IOException {
        boolean compatMode = cache.getCacheConfiguration().compatibility().enabled();
        Class matcherImplClass = compatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class;
        EmbeddedQuery eq = new EmbeddedQuery(cache, request.getJpqlString(), request.getStartOffset(), request.getMaxResults(), matcherImplClass);
        List list = eq.list();
        int projSize = 0;
        if (eq.getProjection() != null && eq.getProjection().length > 0) {
            projSize = eq.getProjection().length;
        }
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? list.size() : list.size() * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                if (compatMode) {
                    o = ProtobufUtil.toWrappedByteArray((SerializationContext)serCtx, o);
                }
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)eq.getResultSize());
        response.setNumResults(list.size());
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }

    private QueryResponse executeQuery(AdvancedCache<byte[], byte[]> cache, SerializationContext serCtx, QueryRequest request) {
        LuceneQueryParsingResult parsingResult;
        SearchManager searchManager = Search.getSearchManager(cache);
        SearchIntegrator searchFactory = searchManager.getSearchFactory();
        QueryCache queryCache = ComponentRegistryUtils.getQueryCache(cache);
        if (queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)request.getJpqlString(), LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)queryCache.get(queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.parseQuery(cache, serCtx, request.getJpqlString(), searchFactory);
                queryCache.put(queryCacheKey, (Object)parsingResult);
            }
        } else {
            parsingResult = this.parseQuery(cache, serCtx, request.getJpqlString(), searchFactory);
        }
        Query luceneQuery = parsingResult.getQuery();
        if (!cache.getCacheConfiguration().compatibility().enabled()) {
            QueryBuilder qb = searchFactory.buildQueryBuilder().forEntity(parsingResult.getTargetEntity()).get();
            luceneQuery = qb.bool().must(((TermMatchingContext)((TermMatchingContext)qb.keyword().onField(TYPE_FIELD_NAME).ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)parsingResult.getTargetEntityName()).createQuery()).must(luceneQuery).createQuery();
        }
        CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[]{parsingResult.getTargetEntity()});
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        int projSize = 0;
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            projSize = parsingResult.getProjections().size();
            cacheQuery = cacheQuery.projection(parsingResult.getProjections().toArray(new String[projSize]));
        }
        if (request.getStartOffset() > 0L) {
            cacheQuery = cacheQuery.firstResult((int)request.getStartOffset());
        }
        if (request.getMaxResults() > 0) {
            cacheQuery = cacheQuery.maxResults(request.getMaxResults());
        }
        List list = cacheQuery.list();
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? list.size() : list.size() * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)cacheQuery.getResultSize());
        response.setNumResults(list.size());
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }

    private LuceneQueryParsingResult parseQuery(AdvancedCache<byte[], byte[]> cache, final SerializationContext serCtx, String queryString, SearchIntegrator searchFactory) {
        LuceneProcessingChain processingChain;
        if (cache.getCacheConfiguration().compatibility().enabled()) {
            final QueryInterceptor queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    MessageMarshaller messageMarshaller = (MessageMarshaller)serCtx.getMarshaller(entityName);
                    Class clazz = messageMarshaller.getJavaClass();
                    return queryInterceptor.isIndexed(clazz) ? clazz : null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities();
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    Descriptor md = serCtx.getMessageDescriptor(type);
                    FieldDescriptor fd = QueryFacadeImpl.this.getFieldDescriptor(md, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return NumericFieldBridge.DOUBLE_FIELD_BRIDGE;
                        }
                        case FLOAT: {
                            return NumericFieldBridge.FLOAT_FIELD_BRIDGE;
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return NumericFieldBridge.LONG_FIELD_BRIDGE;
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return NumericFieldBridge.INT_FIELD_BRIDGE;
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), QueryFacadeImpl.NULL_TOKEN);
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
        }
        return (LuceneQueryParsingResult)new QueryParser().parseQuery(queryString, (AstProcessingChain)processingChain);
    }

    private FieldDescriptor getFieldDescriptor(Descriptor messageDescriptor, String attributePath) {
        FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw new IllegalArgumentException("Unknown field " + name + " in type " + messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) {
                throw new IllegalArgumentException("Field " + name + " from type " + messageDescriptor.getFullName() + " is not indexed");
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }
}

