/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.query.remote.ProtobufMetadataManagerInterceptor;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.ProtobufMetadataManagerInterceptorTest")
public class ProtobufMetadataManagerInterceptorTest
extends MultipleCacheManagersTest {
    private static final Log log = (Log)LogFactory.getLog(ProtobufMetadataManagerInterceptorTest.class, Log.class);

    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.makeCfg());
        this.addClusterEnabledCacheManager(this.makeCfg());
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder makeCfg() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().clustering().cacheMode(CacheMode.REPL_SYNC).clustering().sync().stateTransfer().fetchInMemoryState(true).transaction().lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ProtobufMetadataManagerInterceptor()).after(PessimisticLockingInterceptor.class);
        return cfg;
    }

    public void testValidatePut() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        try {
            this.cache(0).put((Object)42, (Object)"import \"test.proto\";");
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertEquals((Object)"The key must be a string", (Object)e.getMessage());
        }
        try {
            this.cache(0).put((Object)"some.proto", (Object)42);
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertEquals((Object)"The value must be a string", (Object)e.getMessage());
        }
        try {
            cache0.put((Object)"some.xml", (Object)"import \"test.proto\";");
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertEquals((Object)"The key must end with \".proto\" : some.xml", (Object)e.getMessage());
        }
        try {
            cache0.put((Object)"test.proto", (Object)"package x");
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertEquals((Object)"Failed to parse proto file : test.proto", (Object)e.getMessage());
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("a.proto", "package a");
            map.put("b.proto", "package b;");
            cache0.putAll(map);
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof DescriptorParserException));
            Assert.assertTrue((boolean)e.getMessage().contains("Syntax error in a.proto"));
        }
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        this.assertNoTransactionsAndLocks();
    }

    public void testValidateReplace() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        String value = "package X;";
        cache0.put((Object)"test.proto", (Object)value);
        Assert.assertEquals((long)1L, (long)cache0.size());
        Assert.assertEquals((long)1L, (long)cache1.size());
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        try {
            cache0.replace((Object)"test.proto", (Object)"package XYX");
            Assert.fail();
        }
        catch (CacheException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof DescriptorParserException));
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to parse proto file : test.proto"));
        }
        Assert.assertEquals((long)1L, (long)cache0.size());
        Assert.assertEquals((long)1L, (long)cache1.size());
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPut() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.put((Object)"test.proto", (Object)value);
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache0.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache0.get((Object)".errors"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache1.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache1.get((Object)".errors"));
        value = "package foobar;";
        cache0.put((Object)"test.proto", (Object)value);
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPutIfAbsent() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.putIfAbsent((Object)"test.proto", (Object)value);
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache0.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache0.get((Object)".errors"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache1.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache1.get((Object)".errors"));
        cache0.putIfAbsent((Object)"test.proto", (Object)"package foobar;");
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache0.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache0.get((Object)".errors"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache1.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"test.proto", (Object)cache1.get((Object)".errors"));
        value = "package foobar;";
        cache0.put((Object)"test.proto", (Object)value);
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterPutAll() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        String file1 = "import \"missing.proto\";";
        String file2 = "package b;";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a.proto", file1);
        map.put("b.proto", file2);
        cache0.putAll(map);
        Assert.assertEquals((Object)file1, (Object)cache0.get((Object)"a.proto"));
        Assert.assertEquals((Object)file2, (Object)cache0.get((Object)"b.proto"));
        Assert.assertEquals((Object)file1, (Object)cache1.get((Object)"a.proto"));
        Assert.assertEquals((Object)file2, (Object)cache1.get((Object)"b.proto"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache0.get((Object)"a.proto.errors"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache1.get((Object)"a.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"b.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"b.proto.errors"));
        Assert.assertTrue((boolean)cache0.containsKey((Object)".errors"));
        Assert.assertTrue((boolean)cache1.containsKey((Object)".errors"));
        Assert.assertEquals((Object)"a.proto", (Object)cache0.get((Object)".errors"));
        Assert.assertEquals((Object)"a.proto", (Object)cache1.get((Object)".errors"));
        file1 = "package a;";
        map.put("a.proto", file1);
        cache0.putAll(map);
        Assert.assertEquals((Object)file1, (Object)cache0.get((Object)"a.proto"));
        Assert.assertEquals((Object)file1, (Object)cache1.get((Object)"a.proto"));
        Assert.assertEquals((Object)file2, (Object)cache0.get((Object)"b.proto"));
        Assert.assertEquals((Object)file2, (Object)cache1.get((Object)"b.proto"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"a.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"a.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"b.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"b.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    public void testStatusAfterRemove() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Assert.assertTrue((boolean)cache0.isEmpty());
        Assert.assertTrue((boolean)cache1.isEmpty());
        String value = "import \"missing.proto\";";
        cache0.put((Object)"test.proto", (Object)value);
        Assert.assertEquals((Object)value, (Object)cache0.get((Object)"test.proto"));
        Assert.assertEquals((Object)value, (Object)cache1.get((Object)"test.proto"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache0.get((Object)"test.proto.errors"));
        Assert.assertEquals((Object)"Import 'missing.proto' not found", (Object)cache1.get((Object)"test.proto.errors"));
        cache0.remove((Object)"test.proto");
        Assert.assertFalse((boolean)cache0.containsKey((Object)"test.proto"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"test.proto"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)"test.proto.errors"));
        Assert.assertFalse((boolean)cache0.containsKey((Object)".errors"));
        Assert.assertFalse((boolean)cache1.containsKey((Object)".errors"));
        this.assertNoTransactionsAndLocks();
    }

    private void assertNoTransactionsAndLocks() {
        this.assertNoTransactions();
        TestingUtil.assertNoLocks((Cache)this.cache(0));
        TestingUtil.assertNoLocks((Cache)this.cache(1));
    }
}

