/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufMetadataCachePreserveStateAcrossRestarts")
public class ProtobufMetadataCachePreserveStateAcrossRestarts
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager createCacheManager(String persistentStateLocation) throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().enable().persistentLocation(persistentStateLocation);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cacheManager.getCache();
        return cacheManager;
    }

    public void testStatePreserved() throws Exception {
        String persistentStateLocation = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        TestingUtil.recursiveFileRemove((String)persistentStateLocation);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache protoBufMetadaCache = this.cm.getCache("___protobuf_metadata");
                protoBufMetadaCache.put((Object)"test.proto", (Object)"package X;");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache protoBufMetadaCache = this.cm.getCache("___protobuf_metadata");
                AssertJUnit.assertTrue((boolean)protoBufMetadaCache.containsKey((Object)"test.proto"));
            }
        });
    }
}

