/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.List;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class ProtobufIndexedFieldProvider
implements BooleShannonExpansion.IndexedFieldProvider {
    private final Descriptor messageDescriptor;

    public ProtobufIndexedFieldProvider(Descriptor messageDescriptor) {
        this.messageDescriptor = messageDescriptor;
    }

    public boolean isIndexed(List<String> propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (field.getJavaType() == JavaType.MESSAGE) {
                md = field.getMessageType();
                continue;
            }
            if (i != propertyPath.size()) break;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
            return indexingMetadata == null || indexingMetadata.isFieldIndexed(field.getNumber());
        }
        return false;
    }

    public boolean isStored(List<String> propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (field.getJavaType() == JavaType.MESSAGE) {
                md = field.getMessageType();
                continue;
            }
            if (i != propertyPath.size()) break;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageDescriptor.getProcessedAnnotation("Indexed");
            return indexingMetadata == null || indexingMetadata.isFieldStored(field.getNumber());
        }
        return false;
    }
}

