/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.remote.impl.ProtobufMetadataCachePreserveStateAcrossRestartsTest")
public class ProtobufMetadataCachePreserveStateAcrossRestartsTest
extends AbstractInfinispanTest {
    protected EmbeddedCacheManager createCacheManager(String persistentStateLocation) throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().enable().persistentLocation(persistentStateLocation);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cacheManager.getCache();
        return cacheManager;
    }

    public void testStatePreserved() throws Exception {
        String persistentStateLocation = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        Util.recursiveFileRemove((String)persistentStateLocation);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache protobufMetadaCache = this.cm.getCache("___protobuf_metadata");
                protobufMetadaCache.put((Object)"test.proto", (Object)"package X;");
            }
        });
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(this.createCacheManager(persistentStateLocation)){

            public void call() throws Exception {
                Cache protobufMetadaCache = this.cm.getCache("___protobuf_metadata");
                Assert.assertTrue((boolean)protobufMetadaCache.containsKey((Object)"test.proto"));
            }
        });
    }
}

