/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;

public final class JPAProtobufFilterAndConverter
extends JPAFilterAndConverter<Object, Object> {
    private boolean usesValueWrapper;

    public JPAProtobufFilterAndConverter(String jpaQuery, Map<String, Object> namedParameters) {
        super(jpaQuery, namedParameters, ProtobufMatcher.class);
    }

    @Inject
    protected void injectDependencies(Configuration cfg) {
        this.usesValueWrapper = cfg.indexing().index().isEnabled() && !cfg.compatibility().enabled();
    }

    public ObjectFilter.FilterResult filterAndConvert(Object key, Object value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        if (this.usesValueWrapper) {
            value = ((ProtobufValueWrapper)value).getBinary();
        }
        return this.getObjectFilter().filter(value);
    }

    public String toString() {
        return "JPAProtobufFilterAndConverter{jpaQuery='" + this.getJPAQuery() + "'}";
    }

    public static final class Externalizer
    extends AbstractExternalizer<JPAProtobufFilterAndConverter> {
        public void writeObject(ObjectOutput output, JPAProtobufFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.getJPAQuery());
            Map namedParameters = filterAndConverter.getNamedParameters();
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
        }

        public JPAProtobufFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            return new JPAProtobufFilterAndConverter(jpaQuery, namedParameters);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_PROTOBUF_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends JPAProtobufFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(JPAProtobufFilterAndConverter.class);
        }
    }
}

